/*------------------------------------------------------------------------------*
 * File Name:	XFDialog.c	 													*
 * Creation: CPY 1/14/05														*
 * Purpose: X-Function tool														*
 * Copyright (c) Originlab Corp. 2005											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * DG 2/17/05 CENTRALIZE_XFO_AND_NFO											*
 *	YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION								*
 *	CPY 3/3/05 INTERNAL_XF_EDIT													*
 *	CPY 3/9/05 DEFAULT_TO_INTERNAL												*
 *	CPY 3/18/05 KEEP_XF_NAME_FOR_INTERNAL										*
 *	ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH							*
 *	YuI 03/22/05 LOW_LEVEL_FUNCTION_TO_CHECK_RANGE_REALITY						*
 *	CPY 3/31/05 SWITCH_TO_INTERNAL_WITH_DEFAULT_DLG_SHOULD_SET_TO_EMPTY			*
 *	Frank 3/31/05	GET_FILE_FROM_RECENTLY_FILE									*
 *	Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU						*
 *	Frank 4/6/05	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY					*
 *	Frank	4/15/05 CONFUS_OF_VARIABLE_NAME_DOUBLE								*
 *	CPY 4/15/05 SWITCHING_OUTPUT_COL_IN_INTERNAL_SHOULD_USE_NEW_OP				*
 *	Frank	4/19/05 FIXED_ENTER_XF_NAME_AND_CODE_LOST							*
 *	CPY 4/20/05 HIDE_NAME_EDIT_FOR_INTERNAL_MODE								*
 *	CPY 6/2/05 XF_INTERNAL_UPDATE_WITHOUT_EXEC									*
 *	YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG							*
 *  CPY 9/22/05 USE_VAR_OLD_DESC_TO_EDIT_LANGUAGE_DISPLAY_NAME					*
 *	Jasmine 10/27/05 QA70-8039-P6 v8.0323 ASK_BEFORE_UPDATE_DLG					*
 *	Jasmine 10/28/05 QA70-8039-P6 v8.0323 MESSAGE_FOR_SAVING_ERROR				*
 *	DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION						*
 *	Jasmine 01/24/06 v8.0361 SHOW_XF_CONTEXT_MENU								*
 *	CPY 3/15/06 XFDIALOG_FOR_DESIGN_TIME_ONLY									*
 *	Cheney 06/15/06 FIX_BUG_DELETE_VARIABLE										*
 *  Joe    7/21/06  QA70-8039-P14_L4  ADD_OPTION_STRING                         *
 *  Joe    7/24/06  SET_GRIDCOL_HEADER_CENTER                                   *
 *  Joseph 9/01/06 SHOW_LABEL_WHEN_TYPE_CHANGE									*
 *  Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL								*
 *  Iris 10/20/06 TEMP_SOLUTION_AS_DYNA_FAIL_TO_SHOW_CODE_EDITOR				*
 *	Joseph	11/30/06	CHANGE_VALUE_IN_TREE_EDIT_CNTRL							*	
 *  SY 2006-12-18 QA70-9217 v8.0528 EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL		*
 *	Jasmine 03/30/06 DLG_RESIZE_PAINT_MESS_&_FLEX_CNTRL_MOVE_SIZE_PROBLEM		*
 *	TD 5-10-2007 XFUNCTION_BUILDER_NOT_INFORM_ON_RANGE_CHANGE					*
 *	CPY 6/2/2007 FILE_OPEN_USER_XF_NOT_GOING_TO_USER_PATH						*
 *  Iris 06/07/2007 v8.0635 NEW_USER_XF_FOLDER_IF_THIS_FOLDER_IS_NOT_EXISTED    *
 *	Folger 06/13/07 v8.0640 MODIFY_XF_OPEN_AND_SAVE_AS_BEHAVIOR					*
 *	Folger 06/20/07 ASK_SAVE_BEFORE_LOAD_XF										*
 *  Joseph 06/22/07 NOT_OPEN_CODE_BULIDER_IF_NO_XFNAME_AND_POPUP_MSG_BOX		*
 *	Folger 07/31/07 CORRECT_USER_PATH_SAVE_AS_BEHAVIOR							*
 *	Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR								*
 *	Folger 08/10/07 SHOW_SAVEING_ERROR_MSG_FOR_GROUP_FOLDER						*
 *	Folger 08/16/07 ADD_OPEN_GROUP_XF_IN_XF_BUILDER_MENU						*
 *	Jasmine 09/26/07 REMOVE_GROUP_MENU_IF_NO_GROUP_PATH							*
 *	Folger 10/11/07 FIX_BUG_OF_FILE_SAVE_AS										*
 *	Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF					*
 *	ML 11/5/2007 PROOPER_MENU_LANGUAGE_WHEN_MENU_COMES_FROM_DLG_RESOURCE		*
 *	Jasmine 11/09/07 ADDING_RECENT_FILE_LIST_SHOULD_AFTER_MENU_INIT				*
 *	CPY 11/03/07 FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION						*
 *	Hong 01/18/08 v8.0788 FIX_XF_NO_VALID_NAME_CHECK_LEAD_XF_FAIL_RUN_CORRECTLY	*
 *	Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU						*
 *	Folger 01/30/08 QA70-10960 FIX_XF_DIALOG_GRID_COLUMN_SHOWN					*
 *	Folger 03/25/08 NEED_TO_CHECK_MAKE_XFUNCTION_FOLDER							*
 *	Folger 06/16/08 UPDATE_GET_ORIGIN_FILE_PATH_MEOTHD_IN_XF_DIALOG				*
 *	Folger 08/15/08 CENTRALIZE_SUB_PATH_JUDGEMENT								*
 *	Jasmine 10/23/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE			*
 *	YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS									*
 *	Folger 05/25/09 QA80-13664 XF_DIALOG_SHOULD_STAY_AFTER_ENTER_WITH_FOCUS_ON_XF_NAME_EDIT
 *------------------------------------------------------------------------------*/

#include <origin.h>  

#include "DialogEx.h"
#include "XFunctionEx.h"
#include <Operation.h>

#ifdef _FOR_SMART_LOADING_ONLY
//#include "wksOperation.h" //---- CPY 10/14/06 SEPARATE_OUT_OPERATION_BASE_INTO_SEPARATE_HEADER
#endif

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

//#include "XFOperation.h"
// #include "FunctionOrganizer.h"
//#include "FunctionGroup.h"
#include "FileList.h"		///Iris 3/29/05 ADD_RECENT_FILE_LIST
#include "XFDialog.h"
#include <oUtils.h>

//#define _MEASUER_TIME

#define HOUR_GLASS			waitCursor junk;
#ifdef _MEASUER_TIME
	#include <Profiler.h>
	#define PROFILE_HRGLASS		Profiler junk; //HOUR_GLASS	//
#else
	#define PROFILE_HRGLASS		HOUR_GLASS
#endif

typedef bool (*FUNCXFW)(TreeNode &tr, HWND hParent = NULL); 
typedef string (*FUNCFB) (HWND hParent = NULL);

#define STR_XF_MODE "InternalMode"

#define STR_UNTITLED _L("Untitled")

#define STR_DIALOG_NAME				"XFunctionDlg"
#define STR_DEFAULT_OPEN_PATH		"DefaultOpenPath"

	
//---- CPY 11/3/07 AVOID_CODE_DUPLICATION
// I have replaced all 
//+ "X-Functions\\";
// without comments
#define STR_XF_FOLDER_PATH 	STR_XF_FILE_FOLDER "\\"
//----

//------ Folger 08/15/08 CENTRALIZE_SUB_PATH_JUDGEMENT
static	bool	_is_sub_path(LPCSTR lpcszPath, LPCSTR lpcszSubPath)
{
	string	strPath = lpcszPath;
	strPath.MakeUpper();
	string	strSubPath = lpcszSubPath;
	strSubPath.MakeUpper();
	
	return strPath.Find(strSubPath) == 0;
}

static	bool	_is_path_allow_save(LPCSTR lpcszPath, string *pstrSubPath = NULL, bool bShowWarning = false, HWND hWnd = NULL)
{
	string strSystemPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM, STR_XF_FOLDER_PATH);
	string strGroupPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, STR_XF_FOLDER_PATH);
	
	if ( _is_sub_path(lpcszPath, strSystemPath) )
	{
		if ( pstrSubPath )
			*pstrSubPath = strSystemPath;
		if ( bShowWarning )
			MessageBox(hWnd, _L("Can not save in system folder."), _L("X-Function"), MB_OK | MB_ICONEXCLAMATION);
		return false;
	}
	
	if ( !strGroupPath.IsEmpty() && _is_sub_path(lpcszPath, strGroupPath) )
	{
		if ( pstrSubPath )
			*pstrSubPath = strGroupPath;
		if ( bShowWarning )
			MessageBox(hWnd, _L("Can not save in group folder."), _L("X-Function"), MB_OK | MB_ICONEXCLAMATION);
		return false;
	}
	
	return true;
}
//------ End CENTRALIZE_SUB_PATH_JUDGEMENT

BOOL XFunctionDlg::OnDlgResize(int nType, int cx, int cy)
{
	if(!IsInitReady())
		return TRUE;

	MoveControlsHelper	_temp(this);	///Jasmine 03/30/06 DLG_RESIZE_PAINT_MESS_&_FLEX_CNTRL_MOVE_SIZE_PROBLEM

	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	//	uint nButtonIDs[] = {IDC_XF_RUN, IDC_XF_ATTACH_TO, IDC_XF_ATTACH_TO_LABEL, IDC_XF_AUTOUPDATE, 0};
	//	MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
	if( m_bChangeParam )
	{
		uint nButtonIDs[] = {IDC_XF_CANCEL, IDC_XF_OK, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
	}
	else
	{
		uint nButtonIDs[] = {IDC_XF_RUN, IDC_XF_ATTACH_TO, IDC_XF_ATTACH_TO_LABEL, IDC_XF_AUTOUPDATE, 0};
		MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
	}
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	
	// combo after position lost drop length
	/*
	RECT rr;
	m_comboAttachTo.GetWindowRect(&rr);
	m_wndDlg.ScreenToClient(&rr);
	rr.bottom += 5 * RECT_HEIGHT(rr);
	m_comboAttachTo.MoveWindow(&rr);
	*/	
	return TRUE;
}


//--CPY 6/4/05 ON_OK_NEED_TO_PREVENT_CLOSING, to replace Frank 4/19/05	FIXED_ENTER_XF_NAME_AND_CODE_LOST, as enter key is also possible from other places like in grid cell editing
///------ Folger 05/25/09 QA80-13664 XF_DIALOG_SHOULD_STAY_AFTER_ENTER_WITH_FOCUS_ON_XF_NAME_EDIT
//BOOL	XFunctionDlg::OnOK(Control cntrl)
BOOL	XFunctionDlg::OnOK()
///------ End XF_DIALOG_SHOULD_STAY_AFTER_ENTER_WITH_FOCUS_ON_XF_NAME_EDIT
{
	return false;
}
//--

enum {XF_OUTPUT_TAB, XF_COMPILER_TAB};

BOOL XFunctionDlg::OnInitDialog()
{
	vector<string>  vstrTipsUpDown = {"Show More", "Show Less"};
	vector<string> vsBottomTabs = {"Message Log", "Compiler"};
	
	///// Iris 05/28/2007 v8.0628 MAKE_XF_DLG_SIMPLER
#ifdef MAKE_SIMPER_XF_DLG
	TreeEditDlg::OnInitDialog(IDC_XF_GRID, IDC_XF_SHOW_BOTTOM, IDC_XF_BOTTOM_TAB, vstrTipsUpDown, STR_DIALOG_NAME, 0, vsBottomTabs, false);
#else
	TreeEditDlg::OnInitDialog(IDC_XF_OC_EDITOR, IDC_XF_SHOW_BOTTOM, IDC_XF_BOTTOM_TAB, vstrTipsUpDown, STR_DIALOG_NAME, 0, vsBottomTabs, false);
#endif //MAKE_SIMPER_XF_DLG
	/////end MAKE_XF_DLG_SIMPLER
	
	///Jasmine 11/09/07 ADDING_RECENT_FILE_LIST_SHOULD_AFTER_MENU_INIT
	InitToolBar(IDR_XF_TOOLBAR);
	/// ML 11/5/2007 PROOPER_MENU_LANGUAGE_WHEN_MENU_COMES_FROM_DLG_RESOURCE
	SetLangMenu(IDR_XF_MENU);
	/// end PROOPER_MENU_LANGUAGE_WHEN_MENU_COMES_FROM_DLG_RESOURCE
	
	/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
	//initRecentFileListMenu(true);
	m_MRFList.Init(GetSafeHwnd(), IDC_XFM_CLOSE, STR_INI_SECTION_XF_RECENT_FILE, STR_XF_FILE_FOLDER);
	/// END ADD_RECENT_FILE_LIST_CLASS
	///End ADDING_RECENT_FILE_LIST_SHOULD_AFTER_MENU_INIT
	
	PEVENT_FUNC pfn = NULL;//getEventHandler();
	//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	//m_treeEditCntrl.Init(IDC_XF_TREE, false, true, pfn, *this);
	m_treeEditCntrl.Init(IDC_XF_GRID, false, true, pfn, *this);
	Control ctrl = GetItem(IDC_XF_TREE);
	m_DynaCntrl.CreateControl(ctrl.GetSafeHwnd());
	//----
	//m_reCode = GetItem(IDC_XF_OC_EDITOR);
	Control cTmp = GetItem(IDC_XF_OC_EDITOR);
	m_reCode.CreateControl(cTmp.GetSafeHwnd());
	/// Iris 05/28/2007 v8.0628 MAKE_XF_DLG_SIMPLER
#ifdef MAKE_SIMPER_XF_DLG
	m_reCode.Visible = false;
	Control cCodeTitle = GetItem(IDC_XF_OC_EDITOR_TITLE);
	cCodeTitle.Visible = false;
#endif 
	///end MAKE_XF_DLG_SIMPLER

	m_btnAutoUpdate=GetItem(IDC_XF_AUTOUPDATE);
	
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	m_btnOK = GetItem(IDC_XF_OK);
	m_btnCancel = GetItem(IDC_XF_CANCEL);
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	//--CPY 4/14/05
	if(!m_bChangeParam)
		m_nInternalMode= LoadSetting(STR_XF_MODE, 0) ? XFMODE_INTERNAL_NORMAL : XFMODE_EXTERNAL;
	//--
	m_btnAutoUpdate.Check = isInternalXF()?true:false;// CPY 3/18/05 KEEP_XF_NAME_FOR_INTERNAL, default should be auto update
	//m_btnOK=GetItem(IDOK);
	m_comboAttachTo = GetItem(IDC_XF_ATTACH_TO);
	vector<string> vsAttachTypes;
	string str = okutil_xft_get_x_function_attach_types();
	str.GetTokens(vsAttachTypes, '|');
	m_comboAttachTo.ResetContent();
	for(int ii = 0; ii < vsAttachTypes.GetSize(); ii++)
		m_comboAttachTo.AddString(vsAttachTypes[ii]);
		
	m_editXFname = GetItem(IDC_XF_NAME);
	m_staticXFnameLabel = GetItem(IDC_XF_NAME_LABEL);
	m_btnCompile=GetItem(IDC_XF_COMPILE);
	m_btnRun=GetItem(IDC_XF_RUN);
	///end 
	
	loadVariablePaneSize(); ///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU	
	
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	// part related to intialization of default tree is moved to constructor
	//	initXFTree();
	//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
	//updateXFTreeToDlg();
	updateXFTreeToDlg(false, true);
	//------
	/// end XFOPERATION_CHANGE_PARAM
	
	setViewAdvanced(0, false);
	//updateXFTreeToDlg();
	redrawTopPaneFromTree();
	
	m_reMsgLog.Init(IDC_XF_OUTPUT, *this);
	m_reCompilerOutput = GetItem(IDC_XF_COMPILER_OUTPUT);
	
	//updateShowButtons();	///DG 2/2/05 : update btn status by function
	
	UpdateDlgSize();
	SetInitReady();
	
	///Jasmine 09/26/07 REMOVE_GROUP_MENU_IF_NO_GROUP_PATH
	string strGroup = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE);
	if(strGroup.IsEmpty())
	{
		HWND 	hWnd = GetSafeHwnd();
		HMENU 	hMenu = GetMenu(hWnd);
		Menu XFDialogMenu(hMenu);
		XFDialogMenu.RemoveMenu(IDC_XFM_OPEN_GROUP, MF_STRING);
	}
	///End REMOVE_GROUP_MENU_IF_NO_GROUP_PATH
	
	return TRUE;
}
bool XFunctionDlg::askCanExit()
{
	if(!isInternalXF() && isXFChanged())
	{
		string str;
		str.Format("Save changes to %s?", getXFDisplayName());
		int ii = MessageBox(GetSafeHwnd(), str, _L("X-Function"), MB_YESNOCANCEL);
		if(ii == IDCANCEL)
			return false;
		///Jasmine 10/28/05 QA70-8039-P6 v8.0323 MESSAGE_FOR_SAVING_ERROR
		//if(ii == IDYES && !OnFileSave())
			//return false;
		if(ii == IDYES)
		{
			//------ Folger 10/11/07 FIX_BUG_OF_FILE_SAVE_AS
			//string strPath = getXFpath();
			string strPath;
			if(!getFilename(strPath))
				return OnFileSaveAs();
			//------ End FIX_BUG_OF_FILE_SAVE_AS
			//------ Folger 08/15/08 CENTRALIZE_SUB_PATH_JUDGEMENT
			//string strSystemPath = GetAppPath(true) + "X-Functions\\";
			//if(strPath.Find(strSystemPath)== -1)
			if ( _is_path_allow_save(strPath) )
			//------ End CENTRALIZE_SUB_PATH_JUDGEMENT
				return OnFileSave();
			return OnFileSaveAs();
		///End MESSAGE_FOR_SAVING_ERROR
		}
	}
	return true;
}

BOOL XFunctionDlg::OnCancel()
{
	return askCanExit();
}

BOOL XFunctionDlg::OnClose()
{
	PostMessage(WM_CLOSE); 
	return true;
}

void XFunctionDlg::updateDlgToXFTree()
{
	if(-1 < m_treeEditCntrl.GetSelectedRow())
		m_treeEditCntrl.ValidateChanged();	///DG 3/31/05
	if(isViewAdvanced())
	{
	}
	else
	{
		updateDlgEditItemsToXFTree();
		//m_paramTree.AutoUpdate.nVal = m_btnAutoUpdate.Check;
		m_paramTree.XFdescription.strVal = m_strXFdescription;
		
		//---- CPY 9/22/05 USE_VAR_OLD_DESC_TO_EDIT_LANGUAGE_DISPLAY_NAME
		// m_XFO.CopyVariableLabelsToDescriptions(m_paramTree);
		xf_copy_variable_labels_to_descriptions(m_paramTree);
		//----
		
	}
}
void XFunctionDlg::updateDlgEditItemsToXFTree()
{
	if(isViewAdvanced())
		return;
	m_paramTree.codes.code.strVal = m_reCode.Text;
	m_paramTree.XFname.strVal = m_editXFname.Text;	
	m_paramTree.attachTo.nVal = m_comboAttachTo.GetCurSel();
}
	
void XFunctionDlg::checkCorrectXFGUINodes(TreeNode& trBranch)
{
	foreach(TreeNode trn in trBranch.Children)
	{
		if(ONODETYPE_CODE_EDITOR == trn.ID || ONODETYPE_EXTERNAL == trn.ID )
			trn.ID = ONODETYPE_EDIT_BOX_MULTILINE_TEXT;
	}
}

//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
//void XFunctionDlg::updateXFTreeToDlg(bool bRepositionControls)
void XFunctionDlg::updateXFTreeToDlg(bool bRepositionControls, bool bInitDlg)
//------
{
	PROFILE_HRGLASS
	//---- CPY 9/22/05 USE_VAR_OLD_DESC_TO_EDIT_LANGUAGE_DISPLAY_NAME
	if(!isViewAdvanced())
		//m_XFO.CopyVariableDescriptionsToLabels(m_paramTree);
		xf_copy_variable_descriptions_to_labels(m_paramTree);
	//----
	
	// TreeNode trVars=m_XFO.GetVarsNode(m_paramTree);
	TreeNode trVars;
	okutil_xft_GetVarsNode(&trVars, &m_paramTree, NULL);
	//check_update_XF_vars_event_handlers(trVars);
	
	m_treeEditCntrl.ValidateChanged();	///DG 3/31/05
	
	/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
	// m_XFO.CheckUpdateTreeConsistency(m_paramTree, isInternalXF());
	xf_check_update_tree_consistancy(m_paramTree, isInternalXF(), m_bDisableValDataInteractive);
	
	/// end XYDATARANGE_PROPERTY_IMPLEMENTATION
	
	/// Need to update name
	/// TD 2-28-05 QA70-7447 INTENAL_NAME_GENERATION
	if(isInternalXF())
		updateXFFileName();
	/// end INTENAL_NAME_GENERATION
	SetInitReady(false);
	m_bRunSuccess=false;	///DG 2/2/05 : update tree to dlg should update btn status too	
	if(isViewAdvanced())
	{
		//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
		/*
		setTreeViewOptions(m_paramTree);
		m_treeEditCntrl.CreateTreeView();
		m_treeEditCntrl.SetReady(false);
		//out_str("on view tree");
		//out_tree(m_paramTree);	
		m_treeEditCntrl.Update(m_paramTree, true, true);
		*/
		//---- Iris 10/20/06 TEMP_SOLUTION_AS_DYNA_FAIL_TO_SHOW_CODE_EDITOR
		//--- Iris 12/07/2006 Tarak fix the bug, so commented.
		//checkCorrectXFGUINodes(m_paramTree.codes);
		//checkCorrectXFGUINodes(m_paramTree.helpe);
		//---
		///END TEMP_SOLUTION_AS_DYNA_FAIL_TO_SHOW_CODE_EDITOR
		/// SY 2006-12-18 QA70-9217 v8.0528 EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL
		///m_DynaCntrl.SetTree(m_paramTree, DYNACONTROL_BACKGROUND_GRAY);
		m_DynaCntrl.SetTree(m_paramTree, DYNALAYOUT_BACKGROUND_GRAY);
		/// end EDITABLE_PART_ON_NEXT_LINE_FROM_LABEL
		//---- 
	}
	else
	{
		//------ Folger 01/30/08 QA70-10960 FIX_XF_DIALOG_GRID_COLUMN_SHOWN
		////------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
		//if ( !bInitDlg )
			//m_treeEditCntrl.SaveHideCols();
		////------
		vector<byte> vbHidden;
		m_treeEditCntrl.GetHiddenCols(vbHidden);
		for ( int ii=0; ii<vbHidden.GetSize() && vbHidden[ii] == 0; ii++);
		if ( ii != vbHidden.GetSize() )
			m_treeEditCntrl.SaveHideCols();
		//------
		
		///Frank 3/30/05	TREE_EDIT_SUPPORT_MOVE_ROWS
		m_treeEditCntrl.SetTreeNodeMoveRowsAttrib(trVars);
		///End	TREE_EDIT_SUPPORT_MOVE_ROWS
		//out_str("on view simple");
		//out_tree(m_paramTree);
		//out_tree(trVars);
		if(trVars)
			setGridViewOptions(trVars);
		m_treeEditCntrl.SetReady(false);
		m_treeEditCntrl.UpdateGrid(trVars);		
		// <empty> name, Label, IO,DataType, valData, combostr, context,....
		///Joe	7/21/06	QA70-8039-P14_L4  ADD_OPTION_STRING 
		//vector<byte> vbHideCols = {0, 0, 0, 0, 0, 0, 0}
		vector<byte> vbHideCols = {0, 0, 0, 0, 0, 0, 0, 1, 0};
		///End ADD_OPTION_STRING	
		
		//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
		//m_treeEditCntrl.SetHiddenCols(vbHideCols);
		m_treeEditCntrl.LoadHideCols(STR_DIALOG_NAME, "XFList", &vbHideCols);
		//------
		
		m_treeEditCntrl.ResizeCols(0.1, 3.0, 0);
		///----Frank	4/15/05 CONFUS_OF_VARIABLE_NAME_DOUBLE
		m_treeEditCntrl.SetRowHeaderValues();
		///----End	CONFUS_OF_VARIABLE_NAME_DOUBLE
		if(isXFEmpty())
		{
			m_reCode.SetText(NULL);
			m_editXFname.Text = "";
			m_strXFdescription = ""; //CPY I have to keep this as otherwise XF description somehow get put into var
			//m_comboAttachTo.SetCurSel(m_paramTree.attachTo.nVal);
			//m_btnAutoUpdate.Check = false;
		}
		else
		{
			//m_reCode.SetText( m_paramTree.code.strVal);
			m_reCode.Text = ( m_paramTree.codes.code.strVal);
			m_editXFname.Text = m_paramTree.XFname.strVal;
			m_strXFdescription = m_paramTree.XFdescription.strVal; //CPY I have to keep this as otherwise XF description somehow get put into var
			m_comboAttachTo.SetCurSel(m_paramTree.attachTo.nVal);
			//m_btnAutoUpdate.Check = m_paramTree.AutoUpdate.nVal;
		}
		//--- CPY 3/18/05 KEEP_XF_NAME_FOR_INTERNAL
		//m_editXFname.Enable = isInternalXF()?false:true;
		//---
		m_treeEditCntrl.SetReady(true);//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	}
	//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	//m_treeEditCntrl.SetReady(true);	///DG 4/4/05 base class change, should setready 
	//----
	updateShowButtons();
	SetInitReady(true);
	if(bRepositionControls)
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
		
	updateDialogTitle();
}

//---- need to move into GetNBox.h and .c later, after Yuri checked in those files
void getn_tree_set_view_options(TreeNode& tr, bool bRowColors = true, bool bEmptyIndicatorColor = true, bool bSet = true)
{
	if(!bSet) // to remove
	{
		if(bRowColors)
			tr.RemoveAttribute(STR_ATTRIB_TREE_ROW_COLOR);
		if(bEmptyIndicatorColor)
			tr.RemoveAttribute(STR_ATTRIB_TREE_INDICATOR_COLOR);
		
		return;
	}
	string strColors, strSpecialIndicatorColors;
	get_analysis_gui_color(strColors, strSpecialIndicatorColors);
	if(bRowColors)
		tr.SetAttribute(STR_ATTRIB_TREE_ROW_COLOR, strColors);
	if(bEmptyIndicatorColor)
		tr.SetAttribute(STR_ATTRIB_TREE_INDICATOR_COLOR, strSpecialIndicatorColors);
}
//----
void XFunctionDlg::setGridViewOptions(TreeNode& tr)
{
	GETN_USE(tr)
	///Joe    7/24/06  SET_GRIDCOL_HEADER_CENTER
	//int nCols = m_treeEditCntrl.GetCols();
	//for(int ii=0; ii<nCols; ii++)
	//{
		//m_treeEditCntrl.SetColAlignment(ii,flexAlignCenterCenter);
	//}
	///End SET_GRIDCOL_HEADER_CENTER
	GETN_OPTION_EDIT_ALIGN("1|1|1") // CheckBox = Left, Numbers = Center, String = Center
	getn_tree_set_view_options(tr, true, true, false);
}
void XFunctionDlg::setTreeViewOptions(TreeNode& tr)
{
	GETN_USE(tr)
	GETN_OPTION_GRIDLINE(flexGridFlatVert)
	GETN_OPTION_EDIT_ALIGN("0|0|0")
	getn_tree_set_view_options(tr);
}


BOOL XFunctionDlg::OnDestroy(void)
{
	m_treeEditCntrl.SaveHideCols();		//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
	if(!m_bChangeParam)
	{
		int nDefaultInternal = isInternalXF();
		SaveSetting(STR_XF_MODE, nDefaultInternal);
		/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		//m_FileList.SaveList();		///Iris 3/29/05 ADD_RECENT_FILE_LIST
		m_MRFList.SaveList();
		/// END ADD_RECENT_FILE_LIST_CLASS
	}
	//checkPageSaveSettings();
	TreeEditDlg::OnDestroy();
	Project.EnableGUI(TRUE);/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS

	saveVariablePaneSize(); ///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU

	return true;
}
void XFunctionDlg::newColXF(Worksheet& wks, int nCol, bool bUpdateGUI)
{
	vector<string> vsTypes = {"vector", "vector"};
	//m_XFO.ConstructXFunction(m_paramTree, "", vsTypes);
	xf_construct_xfunction(m_paramTree, "", vsTypes);
	//m_paramTree.internal.nVal = 1;
	
	// TreeNode trVars=m_XFO.GetVarsNode(m_paramTree);
	TreeNode trVars;
	okutil_xft_GetVarsNode(&trVars, &m_paramTree, NULL);
	
#ifndef _XF_LT_CALL_IN_VC	
	XVariableHelper xv1(trVars.v1);
	XVariableBase* pVar1 = xv1.Var();
	if( !pVar1 )
	{
		error_report("Failed to construct XVariable");
		return;
	}
	
	pVar1->SetValue("Col(1)");
	pVar1->SetName("x");
	XVariableHelper xv2(trVars.v2);
	XVariableBase* pVar2 = xv2.Var();
	if( !pVar2 )
	{
		error_report("Failed to construct XVariable");
		return;
	}
	string strVal = "Col(" + (nCol+1) + ")";	
	pVar2->SetValue(strVal);
	pVar2->SetIO(false, true);
	pVar2->SetName("y");
#endif //_XF_LT_CALL_IN_VC

	if(bUpdateGUI)
		updateXFTreeToDlg();

}

void XFunctionDlg::initXFTree()
{
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	// init XFTree shold not depend on the actual presence of dialog window
	//	OnFileNew();
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// m_XFO.ConstructXFunction(m_paramTree);
	xf_construct_xfunction(m_paramTree, "");
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	/// end XFOPERATION_CHANGE_PARAM
	//int nDefaultInternal = LoadSetting(STR_XF_MODE, 1);
	//m_paramTree.internal.nVal = nDefaultInternal;//CPY 3/9/05 DEFAULT_TO_INTERNAL	
}
void XFunctionDlg::updateAutoUpdate()
{
//--- CPY 4/14/05 AUTO_UPDATE_NOT_REALLY_NEEDED_TO_BE_SHOWN_IN_ALL_CASES
	/*
	bool bEnable = isAutoUpdatePossible();
	m_btnAutoUpdate.Enable = bEnable;
	m_comboAttachTo.Enable = bEnable;
	*/
//---
}

void 	XFunctionDlg::updateBottomTabDisplay(int nTabToShow) // = -1
{
	if(nTabToShow >= 0)
	{
		m_BottomTab.SetCurSel(nTabToShow);
	}

	int nSelTab = UpdateBottomPaneSubControls();
	switch(nSelTab)
	{
	case XF_OUTPUT_TAB:
		updateMessageLogTab();
		break;
	case XF_COMPILER_TAB:
		updateCompilerOutputTab();
		break;
	default:
		out_str("Error, nTab not a valid tab");
		break;
	}
}
void XFunctionDlg::OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition) //CPY 4/30/05 MOVE_ROW_NEED_UPDATE_IDS
{
	TreeEditDlg::OnAfterMoveRows(ctrl, nRow, pnPosition);
	
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// m_XFO.OnAfterAddInsertVar(m_paramTree);
	xf_on_after_add_insert_var(m_paramTree);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
}

///Jasmine 01/24/06 SHOW_XF_CONTEXT_MENU
//it's XFunctionOrganizer::OnShowMenu in OriginEvents.c
int	XFunctionDlg::ShowContextMenu(TreeNode &trRow, TreeNode &trFunction, int nx, int ny, HWND hWndParent, int nRow, bool bXFDlg, bool bAdvanView)
{
	///Frank 4/4/05	Not need check here.
	//if(!IsFunction(trFunction))
		//return false;
	//if(!IsPopUpMenu(trRow, bAdvanView))
	if(!xf_is_pop_up_menu(trRow, bAdvanView))
		return -1;
	
	//TreeNode trVars=GetVarsNode(trFunction);
	TreeNode trVars;
	okutil_xft_GetVarsNode(&trVars, &trFunction, NULL);
	string strTemp;
	//bool bAllowDelete= trVars.GetNodeCount() > 1 && trRow && trRow.GetAttribute(STR_XF_VARIABLE_NODE_ATTRIB, strTemp);
	bool bAllowDelete = false;
	if(trVars)
	{
		/// TD 8-17-2007 QA80-10249 CREATING_XFUNCTIONS_WITH_NO_ARGS
		//bAllowDelete = trVars.GetNodeCount() > 1 && trRow && trRow.GetAttribute(STR_XF_VARIABLE_NODE_ATTRIB, strTemp);
		bAllowDelete = trRow && trRow.GetAttribute(STR_XF_VARIABLE_NODE_ATTRIB, strTemp);
		/// end CREATING_XFUNCTIONS_WITH_NO_ARGS
	}
	
	//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
	//XFControlMenu myMenu(bAllowDelete, bXFDlg);
	vector<string>	vsColHeading;
	vector<byte>	vbCols;
	//Columns need to be removed:
	//0 : fixed column
	//7 : Context
	//11 : English Help
	//12 : Japanese Help
	//13 : German Help
	//14 : Chinese Help
	//all can been seen from TreeView -> Variables -> v1...
	vector<int>		vnRemove ={0, 7, 11, 12, 13, 14};
	m_treeEditCntrl.GetHiddenCols(vbCols);
	m_treeEditCntrl.GetRowValues(0, vsColHeading);
	XFControlMenu myMenu(bAllowDelete, bXFDlg, vsColHeading, vbCols, vnRemove);
	//------
	
	int nCmd = myMenu.DoTrackPopup(nx, ny, hWndParent, bAllowDelete);
	switch(nCmd)
	{
	case XF_MENU_ADD:
		if(!trVars)
		{
			vector<string> vsTypes = {"vector"};
			//ConstructXFunction(trFunction, "", vsTypes);
			xf_construct_xfunction(trFunction, "", vsTypes);
			//trVars=GetVarsNode(trFunction);
			okutil_xft_GetVarsNode(&trVars, &trFunction, NULL);
			trVars.V1.name.strVal = "";
		}
		else
			//AddNewVar(trVars);
			xf_add_new_var(trVars);
		//AddNewVar(trVars);
		break;
	case XF_MENU_DEL:
		trRow.Remove();
		//---- Cheney 06/15/06 FIX_BUG_DELETE_VARIABLE
		xf_on_after_add_insert_var(trFunction);
		//----END FIX_BUG_DELETE_VARIABLE
		break;
	case XF_MENU_INSERT:
		//InsertNewVar(trVars, nRow);
		//InsertNewVar(trVars, trRow);
		xf_insert_new_var(trVars, trRow);
		break;
	default:
		//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
		if ( nCmd >= XF_MENU_COLUMN )
		{
			int nIndex = nCmd - XF_MENU_COLUMN;
			for ( int ii=0; ii<vnRemove.GetSize() && vnRemove[ii]<=nIndex+ii; ++ii );
			m_treeEditCntrl.HideCol(nIndex + ii, !vbCols[nIndex + ii]);
		}
		//------
		break;
	}
	return nCmd;
}
///DG 2/4/05
bool XFunctionDlg::OnShowMenu(UINT nResIDCtrl, int nx, int ny)
{
	//#ifdef XF_ORGANIZER // DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION	///Jasmine 01/24/06 SHOW_XF_CONTEXT_MENU
	
	//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	//if(IDC_XF_TREE != nResIDCtrl)
	if(IDC_XF_GRID != nResIDCtrl)
	//---- 	
		return false;
	int nRow, nCol;
	//m_treeEditCntrl.FindCell(nx, ny, nRow, nCol);
	bool bFindCell = false;
	if(!isXFEmpty())
		bFindCell = m_treeEditCntrl.FindCell(nx, ny, nRow, nCol);
	bool bAdvancedView=isViewAdvanced();
	if(!bAdvancedView)
	{
		///Frank 4/5/05 Must add 1 if nCol == 0 , because Header col is 0..
		m_treeEditCntrl.GetMouseCell(nRow, nCol);
		if(nCol ==0)
			nCol += 1;
	}
	
	m_treeEditCntrl.SelRow(nRow);
	TreeNode trSel=m_treeEditCntrl.GetTreeNode(nRow, nCol);

	if(trSel && !bAdvancedView)
		trSel = trSel.Parent();	
		
	// int nOtherCmd=m_XFO.OnShowMenu(trSel, m_paramTree, nx, ny, GetSafeHwnd(),nRow, true, bAdvancedView);
	//int nOtherCmd=m_XFO.OnShowMenu(trSel, m_paramTree, nx, ny, GetSafeHwnd(),nRow, true, bAdvancedView);	///Jasmine 01/24/06 SHOW_XF_CONTEXT_MENU
	int nOtherCmd=ShowContextMenu(trSel, m_paramTree, nx, ny, GetSafeHwnd(),nRow, true, bAdvancedView);
	
	switch(nOtherCmd)
	{
	case XF_MENU_ENLARGE:
		return enlargeVariablesPane();
	case XF_MENU_SHRINK:
		return shrinkVariablesPane();
	case -1:		///Frank 4/4/05 invalid case of menu seleted.
		return false;
	default:
		break;
	}
	///end
	
	//------ Folger 01/21/08 QA70-10960 ADD_XF_DIALOG_CONTEXT_MENU
	if ( nOtherCmd >= XF_MENU_COLUMN )
		return true;
	//------
	
	//updateXFTreeToDlg();
	//--- CPY 4/3/05
	/*
	SetInitReady(false);
	m_treeEditCntrl.SetReady(false);
	m_treeEditCntrl.UpdateGrid(trVars);
	SetInitReady(true);
	*/
	///----Frank 4/19/05 FIXED_ENTER_XF_NAME_AND_CODE_LOST
	if(!m_bViewAdvanced)//If simple view, need to update from Dialog to tree of the code
		updateDlgToXFTree();
	///----End FIXED_ENTER_XF_NAME_AND_CODE_LOST

	onFunctionChange();
	updateXFTreeToDlg(true);
	//----
	
	return true;
	
	//#else
	//return false;
	//#endif // XF_ORGANIZER // not used  DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
///End SHOW_XF_CONTEXT_MENU
}
///end

BOOL	XFunctionDlg::OnEditCodeBuilder()
{
	return true;
}

#define	DECL_XF(_XF)	XFunction _XF(m_paramTree, isInternalXF());

BOOL 	XFunctionDlg::OnCompile()
{
#ifndef 	 _XF_LT_CALL_IN_VC //CPY 1/27/06
	updateDlgToXFTree();	///DG 2/2/05 update code to tree
	
	DECL_XF(xf)
	
	if(!xf.Compile(GetSafeHwnd()))
		return onAfterCompile(false);
	
	return onAfterCompile(true);
#endif//#ifndef 	 _XF_LT_CALL_IN_VC //CPY 1/27/06
return false;//wait #ifndef 	 _XF_LT_CALL_IN_VC //CPY 1/27/06
}

///DG 1/20/05
BOOL	XFunctionDlg::OnFileNew()
{
	///Jasmine 10/27/05 QA70-8039-P6 v8.0323 ASK_BEFORE_UPDATE_DLG
	if(!askCanExit())
		return false;
	///End ASK_BEFORE_UPDATE_DLG
	
	// m_XFO.ConstructXFunction(m_paramTree);	///DG 4/2/05
	xf_construct_xfunction(m_paramTree);	
	
	
	
	//m_XFO.New(m_paramTree, "Untitled");	///DG 4/6/05
	updateXFTreeToDlg();
	return true;
}
BOOL	XFunctionDlg::OnNewOpenWizard()
{
	///Jasmine 10/27/05 QA70-8039-P6 v8.0323 ASK_BEFORE_UPDATE_DLG
	if(!askCanExit())
		return false;
	///End ASK_BEFORE_UPDATE_DLG
	
	Function fn = Project.FindFunction("XFWopen", "OriginLab\\XFunctionWiz.cpp");
	FUNCXFW pfn = fn;
	if(pfn)
	{
		//if(isXFEmpty())
		//	m_paramTree.internal.nVal = isInternalXF();		
		//int nOldInternal = m_paramTree.internal.nVal;
		if(pfn(m_paramTree, GetSafeHwnd()))
		{
			//bool bRepositionControls = nOldInternal != m_paramTree.internal.nVal? true:false;
			onFunctionChange();
			updateXFTreeToDlg(true);
		}
	}
	//Visible=true;
	return true;
}

BOOL	XFunctionDlg::OnFileSave()
{
	if(isInternalXF())
		return error_report("XFunctionDlg::OnFileSave, should never come here");
	
	///DG 2/4/05 New function should ask save file name
	string strTemp;
	if(!getFilename(strTemp))
		return OnFileSaveAs();
	///end
	updateDlgToXFTree();
	
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// if(m_XFO.SaveUsingXFname(m_paramTree))
	if( xf_save_using_xf_name(m_paramTree) )
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	{
		updateDialogTitle();
		
		///Iris 3/29/05 ADD_RECENT_FILE_LIST
		/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		//addUpdateRecentFileList(strTemp);
		m_MRFList.AddUpdateRecentFileList(strTemp);
		/// END ADD_RECENT_FILE_LIST_CLASS
		///end ADD_RECENT_FILE_LIST
		
		return true;
	}
	///Jasmine 10/28/05 QA70-8039-P6 v8.0323 MESSAGE_FOR_SAVING_ERROR
	//---Jasmine 10/23/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	//string strErr = "File error while saving to \n"+ strTemp +". \nThe file maybe read-only.";
	//MessageBox(GetSafeHwnd(), strErr, _L("X-Function"), MB_OK | MB_ICONEXCLAMATION);
	popup_errmsg_save_readonly_file( strTemp, GetSafeHwnd() );
	//---end
	///End MESSAGE_FOR_SAVING_ERROR
	return false;
}
//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
BOOL XFunctionDlg::OnContentChange(Control ctrl)
{
	if (m_paramTree.XFname.strVal.CompareNoCase(m_editXFname.Text) != 0)
	{
		m_paramTree.XFname.strVal = m_editXFname.Text;
		onFunctionChange();
	}
	return true;
}
//------ End FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
bool XFunctionDlg::enlargeVariablesPane()
{
	m_nTreeHeightPercent = m_nTreeHeightPercent +VARIABLE_PANE_STEP_INCRE;
	if( m_nTreeHeightPercent >= VARIABLE_PANE_MAX_SIZE )
		m_nTreeHeightPercent = VARIABLE_PANE_MAX_SIZE; 

	return OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
}

bool XFunctionDlg::shrinkVariablesPane()
{
	m_nTreeHeightPercent = m_nTreeHeightPercent  - VARIABLE_PANE_STEP_INCRE;
	if( m_nTreeHeightPercent <= VARIABLE_PANE_MIN_SIZE  )
		m_nTreeHeightPercent = VARIABLE_PANE_MIN_SIZE;
	
	return OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
}
///End	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU


// return false if not yet been saved to file
bool XFunctionDlg::getFilename(string& strfilename, bool bFullpath, bool bInitIfEmpty)
{
	if(isInternalXF())
	{
		strfilename = STR_UNTITLED;
		return false;
	}
	
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION	
	// string strFile = m_XFO.GetFuncFileName(m_paramTree, bFullpath);
	string strFile = okutil_fo_GetFuncFileName(&m_paramTree, bFullpath);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	bool bRet = true;
	string strFullPath;
	//------ End FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	if(strFile.IsEmpty())
	{
		//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
		//if(bInitIfEmpty)
			//strfilename = m_paramTree.XFname.strVal;
		//return false;
		bRet = false;
		//------ End FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	}
	//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	//strfilename = strFile;
	//return true;
	else if (m_paramTree.XFname.strVal.IsEmpty())
		bRet = false;
	else
	{
		strFullPath = GetFilePath(strFile) + m_paramTree.XFname.strVal + STR_XF_FILE_EXT;
	
		if (strFile.CompareNoCase(strFullPath) != 0 && strFullPath.IsFile())
			bRet = false;
	}
	
	strfilename = bRet ? strFullPath : (bInitIfEmpty ? m_paramTree.XFname.strVal : "");
	return bRet;
	//------ End FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
}
int	XFunctionDlg::getPathType()
{
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// string strFile = m_XFO.GetFuncFileName(m_paramTree, true);
	string strFile = okutil_fo_GetFuncFileName(&m_paramTree, true);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	
	if(strFile.IsEmpty())
		return ORIGIN_PATH_UNDEF;
	
	return okutil_get_origin_path_type(strFile);
}

string XFunctionDlg::getXFpath(bool bSaveAs)
{
	/// EJP 2007-06-01 v8.0631 FILE_OPEN_USER_XF_NOT_GOING_TO_USER_PATH
	// This function was still not working as it should according to design.
	// This function seems to only be called for "Open User" and "Save As" so
	// when bSaveAs is false we should always return the user's XF folder.
	// When bSaveAs is true we will use the path where the last XF was loaded
	// from. If no XF was loaded then use the user's XF folder.
	string strPath = xf_get_function_folder(USER_FOLDER);
	if( bSaveAs )
	{
		string strFile = okutil_fo_GetFuncFileName(&m_paramTree, true);
		if( strFile.IsEmpty() )
		{
			string strCategory = xf_get_category_name(m_paramTree);
			if( strCategory.IsEmpty() )
				strCategory = "Miscellaneous";
			strCategory += "\\";
			strPath += strCategory;
			CheckMakePath(strPath);
		}
		else
		{
			strPath = GetFilePath(strFile);
			//------ Folger 08/15/08 CENTRALIZE_SUB_PATH_JUDGEMENT
			/*
			///Folger 06/13/07 v8.0640 MODIFY_XF_OPEN_AND_SAVE_AS_BEHAVIOR
			string strAppPath = GetAppPath(true);
			if(strPath.Find(strAppPath + STR_XF_FOLDER_PATH)> -1)
			{
				//------ Folger 07/31/07 CORRECT_USER_PATH_SAVE_AS_BEHAVIOR
				//string strUserPath = "OriginLab\\";
				//strPath.Insert(strAppPath.GetLength(), strUserPath);
				string strUserPath = GetAppPath(false);
				strPath.Replace(strAppPath, strUserPath);
				//------ End CORRECT_USER_PATH_SAVE_AS_BEHAVIOR
				CheckMakePath(strPath);
			}
			///End MODIFY_XF_OPEN_AND_SAVE_AS_BEHAVIOR
			*/
			string	strSubPath;
			if ( !_is_path_allow_save(strPath, &strSubPath) )
			{
				strPath.MakeUpper();
				strSubPath.MakeUpper();
				
				strPath.Replace(strSubPath, okutil_get_origin_path(ORIGIN_PATH_USER, STR_XF_FOLDER_PATH));
				CheckMakePath(strPath);
			}
			//------ End CENTRALIZE_SUB_PATH_JUDGEMENT
		}
	}
	///Folger 06/13/07 v8.0640 MODIFY_XF_OPEN_AND_SAVE_AS_BEHAVIOR
	else
	{
		//string strTmp = strPath;		//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
		dlg_load_registry(STR_DIALOG_NAME, STR_DEFAULT_OPEN_PATH, strPath);
		//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
		//if (strPath.IsEmpty())
			//strPath = strTmp;
		//------ End CORRECT_OPEN_USER_XF_BEHAVIOR
	}
	///End MODIFY_XF_OPEN_AND_SAVE_AS_BEHAVIOR
	return strPath;
	/// end FILE_OPEN_USER_XF_NOT_GOING_TO_USER_PATH
#ifdef JUNK
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// string strFile = m_XFO.GetFuncFileName(m_paramTree, true);
	string strFile = okutil_fo_GetFuncFileName(&m_paramTree, true);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	
	string strPath;
	if(strFile.IsEmpty() || bSaveAs)
	{
		/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
		// string strCategory = m_XFO.GetCategoryName(m_paramTree);
		// strPath = m_XFO.GetFunctionFolder(USER_FOLDER);
		string strCategory = xf_get_category_name(m_paramTree);
		strPath = xf_get_function_folder(USER_FOLDER);
		/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
		//---------- CPY 6/2/2007 FILE_OPEN_USER_XF_NOT_GOING_TO_USER_PATH
		/*
		if(bSaveAs && strCategory.IsEmpty())
		strCategory = "Miscellaneous";
		if(!strCategory.IsEmpty())
			strCategory += "\\";
		strPath += strCategory;
		CheckMakePath(strPath);
		*/
		if(bSaveAs)
		{
			if(strCategory.IsEmpty())
				strCategory = "Miscellaneous";
			
			strCategory += "\\";
			strPath += strCategory;
			CheckMakePath(strPath);
		}
		if(!bSaveAs)
			return strPath;
		//---------
	}

		strPath = GetFilePath(strFile);
	return strPath;
#endif // JUNK
}

BOOL	XFunctionDlg::OnFileSaveAs()
{
	updateDlgToXFTree();
	vector<string> vsExt={STR_XF_FILE_EXT_SPEC};
	string strXMLFile;
	//int nInternal = m_paramTree.internal.nVal;
	bool bNewFunction = getFilename(strXMLFile, false, true)? false:true;
	string strPath = getXFpath(true);
	
	///Joseph 05/09/07 CREATE_ALL_XF_USER_FOLDERS
	if(strPath.Find("Miscellaneous") >= 0)
	{
		string strXFUserPath = xf_get_function_folder(USER_FOLDER);
		vector<string> vsUserFolderNames;
		int nSize = okutil_find_subfolders(&vsUserFolderNames, strXFUserPath, 3); //just 3 levels
		if(nSize <= 1)
		{
			if(OM_RETURN_OK == OptionalMessage("CreateXFUserFolders", MB_YESNO))
			{
				string strSysXFPath = xf_get_function_folder(SYS_FOLDER);
				vector<string> vsSysFolderNames;
				int nSize = okutil_find_subfolders(&vsSysFolderNames, strSysXFPath, 3); //just 3 level
				
				for(int nn = 0; nn < nSize; nn++)
					CheckMakePath(strXFUserPath + vsSysFolderNames[nn]);
			}
		}
	}
	///End CREATE_ALL_XF_USER_FOLDERS
	
	strXMLFile = GetSaveAsBox(vsExt, strPath, strXMLFile);
	
	//------ Folger 08/15/08 CENTRALIZE_SUB_PATH_JUDGEMENT
	/*
	///Jasmine 10/28/05 QA70-8039-P6 v8.0323 MESSAGE_FOR_SAVING_ERROR
	string strSystemPath = GetAppPath(true) + STR_XF_FOLDER_PATH;
	if(strXMLFile.Find(strSystemPath)> -1)
	{
		MessageBox(GetSafeHwnd(), _L("Can not save in system folder."), _L("X-Function"), MB_OK | MB_ICONEXCLAMATION);
		return false;
	}
	///End MESSAGE_FOR_SAVING_ERROR
	//------ Folger 08/10/07 SHOW_SAVEING_ERROR_MSG_FOR_GROUP_FOLDER
	string strGroupPath = GetAppPath(true) + "Group\\";
	if(strXMLFile.Find(strGroupPath)> -1)
	{
		MessageBox(GetSafeHwnd(), _L("Can not save in group folder."), _L("X-Function"), MB_OK | MB_ICONEXCLAMATION);
		return false;
	}
	//------ End SHOW_SAVEING_ERROR_MSG_FOR_GROUP_FOLDER
	*/
	if ( !_is_path_allow_save(strXMLFile, NULL, true, GetSafeHwnd()) )
		return false;
	//------ End CENTRALIZE_SUB_PATH_JUDGEMENT
	
	//------ Folger 11/02/07 FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	if (!strXMLFile.IsEmpty() && GetFileName(strXMLFile, true).IsEmpty())
	{
		MessageBox(GetSafeHwnd(), _L("X-Function name can not be empty."), _L("X-Function"), MB_OK | MB_ICONEXCLAMATION);
		return false;
	}
	//------ End FIX_BUGS_WHEN_CHANGE_XF_NAME_AND_SAVE_XF
	if(!strXMLFile.IsEmpty())
	{
		string strOldName = m_paramTree.XFname.strVal;
		//m_paramTree.internal.nVal = 0;// must make external firsrt
		/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
		// if(!m_XFO.Save(m_paramTree, strXMLFile))
		if( !xf_save(m_paramTree, strXMLFile) )
		/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
		{
			//m_paramTree.internal.nVal = nInternal;
			/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
			// m_XFO.SetFuncFileName(m_paramTree, NULL);
			okutil_fo_SetFuncFileName(&m_paramTree, NULL);
			/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
			return false;
		}
		//m_paramTree.internal.nVal = nInternal;
		// name might have changed
		if(strOldName.Compare(m_paramTree.XFname.strVal) != 0)
		{
			if(isViewAdvanced())
			{
			}
			else
			{
				m_editXFname.Text = m_paramTree.XFname.strVal;
			}
		}
		updateDialogTitle();
		
		///Iris 3/29/05 ADD_RECENT_FILE_LIST
		//addUpdateRecentFileList(strPath);
		/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		//addUpdateRecentFileList(strXMLFile);
		m_MRFList.AddUpdateRecentFileList(strXMLFile);
		/// END ADD_RECENT_FILE_LIST_CLASS
		///end ADD_RECENT_FILE_LIST
	///Jasmine 10/28/05 QA70-8039-P6 v8.0323 MESSAGE_FOR_SAVING_ERROR
	//}
	//return true;
		return true;
	}
	return false;
	///End MESSAGE_FOR_SAVING_ERROR
}

/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
void	XFunctionDlg::UpdateTreeAfterChangeParamOk(TreeNode& tr)
{
	tr.Replace(m_paramTree, true, true, true);
}

bool	XFunctionDlg::PrepareForChangeParamOperation(TreeNode& trXF, uint uid)
{
	if(!check_x_function_tree(trXF, true))
		return false;
	if(0==uid)
		return false;
	
	m_paramTree = trXF;
	m_uidCurrentOp = uid;
	clearXFChanged();
	m_bChangeParam = true;
	m_nInternalMode = XFMODE_INTERNAL_NORMAL; 
	return true;
}


int		XFunctionDlg::DoModalEx()
{
	InitMsgMap();
	
	return DoModal();
}

void		XFunctionDlg::Reset()
{
	m_bViewAdvanced = false;
	m_nInternalMode = XFMODE_EXTERNAL;
	m_uidCurrentOp = 0;
	m_bIOChangedNeedOpReset = false;
	m_bChangeParam = FALSE;
	m_bChangeParamOk = FALSE; /// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	/// TD 9-12-05 QA70-7403 XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
	m_bSecondViewOpenInCodeBuilder = FALSE;
	/// end XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER

	m_bDisableValDataInteractive = true;//----- CPY 3/15/06 XFDIALOG_FOR_DESIGN_TIME_ONLY

	initXFTree();
}
/// end XFOPERATION_CHANGE_PARAM

bool XFunctionDlg::openXF(const string& strXMLFile)
{
	//----- CPY 3/15/06 XFDIALOG_FOR_DESIGN_TIME_ONLY
	DWORD dwCntrl = XFLOAD_SET_NAME_FILE | XFLOAD_EVENT_HANDLERS;
	if(m_bDisableValDataInteractive)
		dwCntrl |= XFLOAD_DISABLE_GUI_INTERFACE;
	//-----
	
	XFVARPDS _junk; //----- CPY 11/03/07 FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION
	
	if( !strXMLFile.IsEmpty()&& okutil_xft_Load(&m_paramTree, strXMLFile, "", dwCntrl) )
	{		
		m_nInternalMode = XFMODE_EXTERNAL;
		m_btnAutoUpdate.Check = false;// external XF, better default to not AutoUpdate
		/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
		onAfterXFLoad(m_paramTree);
		/// end CUSTOM_XF_DIALOGS
		updateXFTreeToDlg();
		return true;
	}
	return false;
}

/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
void 	XFunctionDlg::onAfterXFLoad(TreeNode& trXF)
{
#ifdef CUSTOM_XF_DIALOG
	TreeNode trGetNBox = trXF.FindNodeByAttribute(STR_DATAID_ATTRIB, IDXF_USGCTXT_GETN_DLG);
	if( trGetNBox.IsValid() && (trGetNBox.nVal == XF_GETN_CUSTOM) )
	{
		TreeNode trFunction = trXF.FindNodeByAttribute(STR_DATAID_ATTRIB, IDXF_USGCTXT_CUSTOM_DIALOG_FILE_NAME_FUNCTION_NAME);
		if( trFunction.IsValid() )
		{
			trFunction.Show = TRUE;
		}
	}
#endif // CUSTOM_XF_DIALOG	
}
/// end CUSTOM_XF_DIALOGS
BOOL	XFunctionDlg::OnOpenSystem()
{
	//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
	////outputOpMsgLog("calling File Open");
	//vector<string> vsExt={STR_XF_FILE_EXT_SPEC};
	////string strXMLFile=GetOpenBox( vsExt, m_XFO.GetXFunctionFolder()+m_XFO.GetCategoryName(m_paramTree)+"\\"); ///DG CENTRALIZE_XFO_AND_NFO
	//string strInitPath = GetAppPath(true) + "X-Functions\\";
	//string strXMLFile=GetOpenBox( vsExt, strInitPath);
	//
	/////Joseph 01/12/06 FIX_BUG_ON_FILE_DLG
	////Click Cancel on file dialog, it should not open "save current xf" msg box 
	//if(!strXMLFile.IsEmpty())
	/////End FIX_BUG_ON_FILE_DLG
	//{
		/////Jasmine 10/27/05 QA70-8039-P6 v8.0323 ASK_BEFORE_UPDATE_DLG
		//if(!askCanExit())
			//return false;
		/////End ASK_BEFORE_UPDATE_DLG
	/////Joseph 01/12/06 FIX_BUG_ON_FILE_DLG
	//}
	/////End FIX_BUG_ON_FILE_DLG
	//
	////openXF(strXMLFile);
	//if(openXF(strXMLFile))
		///// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		////addUpdateRecentFileList(strXMLFile);
		//m_MRFList.AddUpdateRecentFileList(strXMLFile);
		///// END ADD_RECENT_FILE_LIST_CLASS
//
	//return true;
	//------ Folger 06/16/08 UPDATE_GET_ORIGIN_FILE_PATH_MEOTHD_IN_XF_DIALOG
	//string strInitPath = GetAppPath(true) + STR_XF_FOLDER_PATH;
	string strInitPath = okutil_get_origin_path(ORIGIN_PATH_SYSTEM, STR_XF_FILE_FOLDER, TRUE);
	//------
	return openFile(strInitPath);
	//------ End CORRECT_OPEN_USER_XF_BEHAVIOR
}
//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
BOOL XFunctionDlg::OnOpenUser()
{
	//------ Folger 06/16/08 UPDATE_GET_ORIGIN_FILE_PATH_MEOTHD_IN_XF_DIALOG
	//string strInitPath = GetAppPath(false) + STR_XF_FOLDER_PATH;
	string strInitPath = okutil_get_origin_path(ORIGIN_PATH_USER, STR_XF_FILE_FOLDER, TRUE);
	//------
	return openFile(strInitPath);
}
//------ End CORRECT_OPEN_USER_XF_BEHAVIOR

//------ Folger 08/16/07 ADD_OPEN_GROUP_XF_IN_XF_BUILDER_MENU
BOOL XFunctionDlg::OnOpenGroup()
{
	//------ Folger 06/16/08 UPDATE_GET_ORIGIN_FILE_PATH_MEOTHD_IN_XF_DIALOG
	//string strInitPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, NULL, TRUE) + STR_XF_FOLDER_PATH;
	string strInitPath = okutil_get_origin_path(ORIGIN_PATH_GROUP, STR_XF_FILE_FOLDER, TRUE);
	//------
	return openFile(strInitPath);
}
//------ End ADD_OPEN_GROUP_XF_IN_XF_BUILDER_MENU

BOOL	XFunctionDlg::OnFileOpen()
{
	//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
	////outputOpMsgLog("calling File Open");
	//vector<string> vsExt={STR_XF_FILE_EXT_SPEC};
	////string strXMLFile=GetOpenBox( vsExt, m_XFO.GetXFunctionFolder()+m_XFO.GetCategoryName(m_paramTree)+"\\"); ///DG CENTRALIZE_XFO_AND_NFO
	//string strInitPath = getXFpath();
	///// Iris 06/07/2007 v8.0635 NEW_USER_XF_FOLDER_IF_THIS_FOLDER_IS_NOT_EXISTED
	//if( !strInitPath.IsPath() )
		//CreateDirectory(strInitPath, NULL);
	/////end NEW_USER_XF_FOLDER_IF_THIS_FOLDER_IS_NOT_EXISTED
	//string strXMLFile=GetOpenBox( vsExt, strInitPath);
	//
	/////Joseph 01/12/06 FIX_BUG_ON_FILE_DLG
	////Click Cancel on file dialog, it should not open "save current xf" msg box 
	//if(!strXMLFile.IsEmpty())
	/////End FIX_BUG_ON_FILE_DLG
	//{
		/////Jasmine 10/27/05 QA70-8039-P6 v8.0323 ASK_BEFORE_UPDATE_DLG
		//if(!askCanExit())
			//return false;
		/////End ASK_BEFORE_UPDATE_DLG
	/////Joseph 01/12/06 FIX_BUG_ON_FILE_DLG
	//}
	/////End FIX_BUG_ON_FILE_DLG
	/////Iris 3/29/05 ADD_RECENT_FILE_LIST
	////openXF(strXMLFile);
	//if(openXF(strXMLFile))
		///// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
		////addUpdateRecentFileList(strXMLFile);
	//{
		//m_MRFList.AddUpdateRecentFileList(strXMLFile);
		//dlg_save_to_registry("XFunctionDlg", "DefaultOpenPath", GetFilePath(strXMLFile));	///Folger 06/13/07 v8.0640 MODIFY_XF_OPEN_AND_SAVE_AS_BEHAVIOR
	//}
		///// END ADD_RECENT_FILE_LIST_CLASS
//
	/////end ADD_RECENT_FILE_LIST
	//
	//return true;
	
	string strInitPath = getXFpath();
	return openFile(strInitPath, true);
	//------ End CORRECT_OPEN_USER_XF_BEHAVIOR
}
	
string XFunctionDlg::getXFDisplayName()
{
	string strDlgTitle;
	if(isInternalXF())
	{
		strDlgTitle = m_strInternalFilename;
	}
	else
	{
		//strCategoryName=m_XFO.GetCategoryName(m_paramTree);
		/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
		// string strFilename = m_XFO.GetFuncFileName(m_paramTree, true);
		string strFilename = okutil_fo_GetFuncFileName(&m_paramTree, true);
		/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
		
		if(!strFilename.IsEmpty())
		{
			//if(!strCategoryName.IsEmpty())
			//	strDlgTitle.Format("%s%s%s", "[", strCategoryName, "]");
			string strCompositeName = okutil_composite_name_from_file_path(strFilename, STR_XF_FILE_FOLDER);
			
			strDlgTitle+= strCompositeName;
		}
		else
			strDlgTitle = STR_UNTITLED;
	}
	return strDlgTitle;
}

void XFunctionDlg::updateDialogTitle()
{
	string strDlgTitle = getXFDisplayName();
	if(isXFChanged())
		strDlgTitle+='*';
	//-------- CPY 10/21/05 per Easwar suggestion
	//m_wndDlg.Text = "X-Function - " + strDlgTitle;
	string strDlgName = _L("X-Function Builder"); 
	m_wndDlg.Text = strDlgName + " - " + strDlgTitle;
	//--------
}

/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
#ifdef CUSTOM_XF_DIALOG
void 	XFunctionDlg::onChangeGetNOption(int nRow, int nCol)
{
	if( !isViewAdvanced() )
	{
		ASSERT(FALSE); // how can we change GetNOption in non-advanced view?
		return;
	}

	TreeNode trRow = m_DynaCntrl.GetTreeNode(nRow, nCol);
	if( !trRow )
		return;
	
	TreeNode trFunction = trRow.NextNode;
	trFunction.Show = (trRow.nVal == XF_GETN_CUSTOM);
	updateXFTreeToDlg();
}
#endif // CUSTOM_XF_DIALOG
/// end CUSTOM_XF_DIALOGS
void XFunctionDlg::OnAfterValueChange(int nRow, int nCol)
{
	//--- Iris 11/03/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	//TreeNode trRow=m_treeEditCntrl.GetTreeNode(nRow, nCol);

	/// TD 08-13-07 XFN_ARG_TYPE_CHANGE_FROM_GRID_DOES_NOT_UPDATE_PROPERLY
	//TreeNode trRow = m_DynaCntrl.GetTreeNode(nRow, nCol);
	TreeNode trRow;
	if(isViewAdvanced())
	{
		trRow = m_DynaCntrl.GetTreeNode(nRow, nCol);
	}		
	/// end XFN_ARG_TYPE_CHANGE_FROM_GRID_DOES_NOT_UPDATE_PROPERLY
	//
	bool bFromGrid = false; ///Joseph 01/17/07 FIX_BUG_ON_XFRANGE_IN_GRID
	///Joseph	11/30/06	CHANGE_VALUE_IN_TREE_EDIT_CNTRL
	if(!trRow)
	{
		trRow = m_treeEditCntrl.GetTreeNode(nRow, nCol);
		bFromGrid = true; ///Joseph 01/17/07 FIX_BUG_ON_XFRANGE_IN_GRID
	}
	///End CHANGE_VALUE_IN_TREE_EDIT_CNTRL
	//--- 
	if(!trRow)
	{
		error_report("XFunctionDlg::OnAfterValueChange found nRow has no tree node");
		return;
	}
	//out_str("on after grid val change");
	//TreeNode trVar=trRow.Parent();
	int nRowID=trRow.DataID;
	switch(nRowID)
	{
	case IDV_NAME:
		onChangeVarName(nRow, nCol); /// Hong 01/18/08 v8.0788 FIX_XF_NO_VALID_NAME_CHECK_LEAD_XF_FAIL_RUN_CORRECTLY
		break;
	case IDV_DESCRIPTION:
		xf_copy_variable_labels_to_descriptions(m_paramTree);  ///Joseph 9/01/2006 SHOW_LABEL_WHEN_TYPE_CHANGE
		break;
	case IDV_IO:
		updateAutoUpdate();
		break;
	case IDV_TYPE:
		updateDlgEditItemsToXFTree();
		///Joseph 01/18/07 FIX_BUG_ON_XFRANGE_IN_GRID
		if(bFromGrid)
			m_treeEditCntrl.ValidateChanged();
		else
		///End FIX_BUG_ON_XFRANGE_IN_GRID
			onChangeVarType(nRow, nCol);
		resetLinkedOperation();		//-------- CPY 4/15/05 SWITCHING_OUTPUT_COL_IN_INTERNAL_SHOULD_USE_NEW_OP
		/// TD 08-13-07 XFN_ARG_TYPE_CHANGE_FROM_GRID_DOES_NOT_UPDATE_PROPERLY
		if(!isViewAdvanced())
		{
			DECL_XF(xf); // This will synchronise ID's with type. maybe a simpler solution can be deviced
		}		
		/// end XFN_ARG_TYPE_CHANGE_FROM_GRID_DOES_NOT_UPDATE_PROPERLY
		break;
	case IDV_DATA:
		updateDlgEditItemsToXFTree();
		onChangeVarData(nRow, nCol);
		resetLinkedOperation();		//-------- CPY 4/15/05 SWITCHING_OUTPUT_COL_IN_INTERNAL_SHOULD_USE_NEW_OP
		break;
		
	/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
#ifdef CUSTOM_XF_DIALOG	
	case IDXF_USGCTXT_GETN_DLG:
		onChangeGetNOption(nRow, nCol);
		break;
		
	case IDXF_USGCTXT_CUSTOM_DIALOG_FILE_NAME_FUNCTION_NAME:
		updateDlgEditItemsToXFTree();
		break;
#endif// CUSTOM_XF_DIALOG
	/// end CUSTOM_XF_DIALOGS		
	default:
		break;
	}
	onFunctionChange();	
	
}
///Joseph 01/18/07 REMOVE_FUNCTION_BROWER
////return FALSE if not handled, and continue to be processed
////return TRUE will stop default processing
//BOOL XFunctionDlg::OnOCEditorKey(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
//{
	//if('H' == wParam && CNTRL_DOWN)
	//{
		//openFunctionBrowser();
		//return true;
	//}
	//return false;
//}
///End REMOVE_FUNCTION_BROWER
int XFunctionDlg::getInternalEditMode()
{
	if(isXFChanged())
		return XFMODE_INTERNAL_EDITING;
	
	return XFMODE_INTERNAL_NORMAL;
}
bool XFunctionDlg::isXFChanged()
{	
	return tree_node_changed(m_paramTree, false);
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// return m_XFO.CheckChanged(m_paramTree);
//	string strTemp;
//	return m_paramTree.GetAttribute(STR_CHANGED_ATTRIB, strTemp);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
}
void XFunctionDlg::clearXFChanged()
{
	// m_XFO.ClearChanged(m_paramTree);
	//tr_clear_changed_attrib(m_paramTree);
	tree_node_changed(m_paramTree, true);
}

bool XFunctionDlg::isInternalXF()// = true)//CPY 2/28/05
{
	/*
	if(bFromTree)
	{
		if(m_paramTree.internal)
			m_nInternalMode = m_paramTree.internal.nVal==0?XFMODE_EXTERNAL : getInternalEditMode();
		//else
		//	error_report("XFunctionDlg::isInternalXF found XF tree invalid");
	}
	*/
	return XFMODE_EXTERNAL == m_nInternalMode? false:true;
}
bool XFunctionDlg::isXFEmpty()
{
	if(!check_x_function_tree(m_paramTree, false))
		return true;
	return false;
}
void XFunctionDlg::setXFEmpty(bool bUpdateGUI)
{
	m_paramTree.Reset();
	if(bUpdateGUI)
		updateXFTreeToDlg();
}
//--- CPY 3/31/05 SWITCH_TO_INTERNAL_WITH_DEFAULT_DLG_SHOULD_SET_TO_EMPTY
bool XFunctionDlg::isXFBasicallyEmpty()
{	
	TreeNode trXFTree = m_paramTree;
	
	if(!trXFTree || !trXFTree.vars.IsValid() || !trXFTree.codes.code.IsValid())
		return true;
	
	string strCode = m_paramTree.codes.code.strVal;
	if(strCode.GetLength() > 3 || trXFTree.vars.GetNodeCount() > 1)
		return false;

	return true;	
}
//---
bool XFunctionDlg::isVarHasIO(bool bExcludeInputOutput) //=true
{
	if(isXFEmpty())
		return false;
	int nInput, nOutput, nIO;
	
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// if(!m_XFO.CountVariables(m_paramTree, nInput, nOutput, nIO))
	if(	!xf_count_variables(m_paramTree, nInput, nOutput, nIO) )
		return false;
	
	if(bExcludeInputOutput && nIO)
		return false;
	if(nInput > 0 && nOutput > 0)
		return true;
	
	return false;
}
bool XFunctionDlg::isRunSuccess()
{
	return m_bRunSuccess;
}
bool XFunctionDlg::isAllowAutoUpdateExternal()
{
	return false;//true;
}
bool XFunctionDlg::isSaveToOperation(bool bAutoUpdateCheck, bool bExecuteButton)
{
	int nInput, nOutput, nIO;
	
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// if(!m_XFO.CountVariables(m_paramTree, nInput, nOutput, nIO))
	if(	!xf_count_variables(m_paramTree, nInput, nOutput, nIO) )
		return false;
	
	if(isInternalXF())
	{
		return nOutput > 0? true:false;
	}
	else
	{
		if(nIO > 0)
			error_report("AutoUpdate dose not support Input-Output variable");
		
		return bAutoUpdateCheck;
	}
}

bool XFunctionDlg::isAutoUpdatePossible()
{
	/// YuI 03/22/05 LOW_LEVEL_FUNCTION_TO_CHECK_RANGE_REALITY
	/*
	
	if(isInternalXF())
		return isVarHasIO();
	int nInput, nOutput, nIO;
	if(!m_XFO.CountVariables(m_paramTree, nInput, nOutput, nIO))
		return false;
	if(nIO)
		return false;
	if(nInput > 0)
		return true;
	
	return false;
	*/
	
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// return m_XFO.IsAutoupdatePossible(m_paramTree);
	return xf_is_autoupdate_possible(m_paramTree);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	
	/// end LOW_LEVEL_FUNCTION_TO_CHECK_RANGE_REALITY	
}

void XFunctionDlg::updateShowButtons()
{
	updateAutoUpdate();
	//--- CPY 4/14/05 AUTO_UPDATE_NOT_REALLY_NEEDED_TO_BE_SHOWN_IN_ALL_CASES
	/*
	//m_btnOK.Enable=isRunSuccess();
	bool bShow = true;//m_bViewAdvanced? false:true;
	//if(!isInternalXF(false) || isXFEmpty())
	if(isXFEmpty())
		bShow = false;
	if(!isAllowAutoUpdateExternal() && !isInternalXF())
		bShow = false;
	*/
	bool bShow = false;
	//----
	m_comboAttachTo.Visible = false;//bShow;
	GetItem(IDC_XF_ATTACH_TO_LABEL).Visible = false;//bShow;
	m_btnAutoUpdate.Visible = bShow;
	m_btnRun.Enable = isXFEmpty()? false:true;
	//---- CPY 4/20/05 HIDE_NAME_EDIT_FOR_INTERNAL_MODE
	bool bShowName = true;
	if(isViewAdvanced() || isInternalXF())
		bShowName = false;
	
	m_editXFname.Visible = bShowName;
	m_staticXFnameLabel.Visible = bShowName;
	//---- end HIDE_NAME_EDIT_FOR_INTERNAL_MODE
	
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	/// Iris 05/28/2007 v8.0628 MAKE_XF_DLG_SIMPLER
#ifdef MAKE_SIMPER_XF_DLG
	m_btnRun.Visible = false;
	Control brb = GetItem(IDC_XF_SHOW_BOTTOM);
	brb.Visible = false;	
#else
	m_btnRun.Visible = !m_bChangeParam;
#endif //MAKE_SIMPER_XF_DLG
	///end MAKE_XF_DLG_SIMPLER
	
	
	m_btnOK.Visible = m_bChangeParam;
	m_btnCancel.Visible = m_bChangeParam;
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG	

}

void XFunctionDlg::openFunctionBrowser()
{
	Function fn = Project.FindFunction("FBopen", "OriginLab\\FunctionBrowser.cpp");
	FUNCFB pfn = fn;
	if(pfn)
	{
		//Visible=false; CPY 3/4/05, better keep XF dialog open when cntrl-H
		string strFunction=pfn(GetSafeHwnd());
		m_reCode.Text+=strFunction;
	}
	//Visible=true;
}
///end 


	/*
// only rMain.bottom usful actually
//virtual 
void XFunctionDlg::PositionTopPaneMainItem(Control& cMainItem, RECT& rMain, int cx, uint nMainItemID)
{
	RECT rr;
	GetControlClientRect(IDC_XF_VARS_TITLE, rr);
	int nTitleHeight = RECT_HEIGHT(rr);
	int nEdge = GetControlGap();
	int ny = rMain.bottom;
	int nHeight = rMain.bottom;
	ny -= 2* nTitleHeight + 3 * nEdge;
	double dRatio = 0.5;
	int nyGrid = 0.5 + nHeight * dRatio;
	int nyEdit = nHeight - nyGrid;
	if(SizeControl(IDC_XF_VARS_GRID, cx - 2*nEdge, nyGrid) > 0)
		out_int("edit height = ", nyEdit);
	SizeControl(IDC_XF_OC_EDITOR, cx - 2*nEdge, nyEdit);
	uint unIDs[] = {IDC_XF_VARS_TITLE, IDC_XF_VARS_GRID, IDC_XF_OC_EDITOR_TITLE, IDC_XF_OC_EDITOR, 0};
	ArrangeControlsTopDown(unIDs, nEdge, nEdge);
	MultiPaneDlg::PositionTopPaneMainItem(cMainItem, rMain, cx, nMainItemID);
}	*/

#ifdef MAKE_SIMPER_XF_DLG	
void XFunctionDlg::getViewBasicTopPaneIDs(vector<uint>& vnTop, int* ptopResizeItem)
{
	vector<uint> vn = {IDC_XF_NAME_LABEL, IDC_XF_NAME, IDC_XF_VARS_TITLE, IDC_XF_GRID};
	vector<uint> vnHideName = {IDC_XF_VARS_TITLE, IDC_XF_GRID};

	if(ptopResizeItem && isInternalXF() && !isViewAdvanced())
	{
		*ptopResizeItem = 1;
		vnTop = vnHideName;
		return;
	}
	if(ptopResizeItem)
	{
		*ptopResizeItem = 3;
	}
	//---
	vnTop = vn;	
}
		
#else //MAKE_SIMPER_XF_DLG
		
//--- CPY 4/20/05 HIDE_NAME_EDIT_FOR_INTERNAL_MODE
//ptopResizeItem = NULL, then only getting id, so will get all regardless of internal mode or not
//---
void XFunctionDlg::getViewBasicTopPaneIDs(vector<uint>& vnTop, int* ptopResizeItem, int* pbottomResizeItem)
{
	//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	//vector<uint> vn = {IDC_XF_NAME_LABEL, IDC_XF_NAME, IDC_XF_VARS_TITLE, IDC_XF_TREE, IDC_XF_OC_EDITOR_TITLE, IDC_XF_OC_EDITOR};
	vector<uint> vn = {IDC_XF_NAME_LABEL, IDC_XF_NAME, IDC_XF_VARS_TITLE, IDC_XF_GRID, IDC_XF_OC_EDITOR_TITLE, IDC_XF_OC_EDITOR};
	//----
	
	//--- CPY 4/20/05 HIDE_NAME_EDIT_FOR_INTERNAL_MODE
	//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	//vector<uint> vnHideName = {IDC_XF_VARS_TITLE, IDC_XF_TREE, IDC_XF_OC_EDITOR_TITLE, IDC_XF_OC_EDITOR};
	vector<uint> vnHideName = {IDC_XF_VARS_TITLE, IDC_XF_GRID, IDC_XF_OC_EDITOR_TITLE, IDC_XF_OC_EDITOR};
	//----

	if(ptopResizeItem && pbottomResizeItem && isInternalXF() && !isViewAdvanced())
	{
		*ptopResizeItem = 1;
		*pbottomResizeItem = 3;
		vnTop = vnHideName;
		return;
	}
	if(ptopResizeItem && pbottomResizeItem)
	{
		*ptopResizeItem = 3;
		*pbottomResizeItem = 5;
	}
	//---

	vnTop = vn;
}
#endif //MAKE_SIMPER_XF_DLG


//virtual 
bool XFunctionDlg::GetTopPaneControls(vector<uint>& vnTopDownIDs, vector& vdHeightRatios)
{
	if(isViewAdvanced())
	{
		vnTopDownIDs.SetSize(1);
		vdHeightRatios.SetSize(1);
		vnTopDownIDs[0] = IDC_XF_TREE;
		vdHeightRatios[0] = 1;
		return true;
	}

	vector<uint> vn;
#ifdef MAKE_SIMPER_XF_DLG	
	int nTreeIndex;	
	getViewBasicTopPaneIDs(vn, &nTreeIndex);
#else
	int nTreeIndex, nRichEditIndex;
	getViewBasicTopPaneIDs(vn, &nTreeIndex, &nRichEditIndex);	
#endif //MAKE_SIMPER_XF_DLG

	vnTopDownIDs = vn;
	vdHeightRatios.SetSize(vn.GetSize());
	vdHeightRatios = 0;// 0 to indicate no size change
	vdHeightRatios[1] = -1; // <0 to indicate position horizontally, -1 to position to the right of previous
	
#ifdef MAKE_SIMPER_XF_DLG	
	m_nTreeHeightPercent = 100;
	vdHeightRatios[nTreeIndex] = m_nTreeHeightPercent/100.0;
#else
	///Frank 4/1/05	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
	//int nTreeHeightPercent = 40;
 	int nTreeHeightPercent = m_nTreeHeightPercent;
	///End	ADD_INSERT_AND_OPERATOR_PANE_SIZE_MENU
	vdHeightRatios[nTreeIndex] = nTreeHeightPercent/100.0;
	vdHeightRatios[nRichEditIndex] = (100-nTreeHeightPercent)/100.0;
#endif //MAKE_SIMPER_XF_DLG

	return true;
}

void XFunctionDlg::redrawTopPaneFromTree()
{
	Control cMainItem;// not really needed as we always return true from GetTopPaneControls and thus will never use this for default drawing
	
	vector<uint> vnAdv, vnBasic;
	vnAdv.Add(IDC_XF_TREE);
	getViewBasicTopPaneIDs(vnBasic);
	if(isViewAdvanced())// id might be in both array, so cannot just hide one and show the other
	{
		ShowControls(vnBasic,false);
		ShowControls(vnAdv, true);
	}
	else
	{
		ShowControls(vnBasic,true);
		ShowControls(vnAdv, false);//---- Iris 10/19/06 REPLACE_TREE_EDIT_WITH_DYNA_CTRL
	}
		
	int cx = GetDlgExtent(false);
	MultiPaneDlg::PositionTopPaneMainItem(cMainItem, m_rTopPaneMain, cx, GetTopPaneMainID());
	updateXFTreeToDlg();
}
//virtual 
int XFunctionDlg::GetTopPaneMainID()
{
#ifdef MAKE_SIMPER_XF_DLG
	return isViewAdvanced()? IDC_XF_TREE : IDC_XF_GRID;
#else
	return isViewAdvanced()? IDC_XF_TREE : IDC_XF_OC_EDITOR;
#endif //MAKE_SIMPER_XF_DLG
}
/*

BOOL	XFunctionDlg::OnInteractivePopUp(Control ctrl)
{
	Window wnd = GetWindow();
	RECT rectButton;
	ctrl.GetWindowRect(&rectButton);
	int nX = (rectButton.left + rectButton.right) / 2;
	int nY = (rectButton.top + rectButton.bottom) / 2;
	
	return m_treeEditCntrl.DoInteractivePopUp(&wnd, nX, nY);
}
BOOL	XFunctionDlg::OnInteractiveXYDataRange(Control ctrl)
{
	Window wnd = GetWindow();
	return m_treeEditCntrl.DoXYDataRangeDlg(&wnd, FALSE);
}
BOOL	XFunctionDlg::OnSelectionChange()
{
	//out_str("OnSelectionChange");
	if( !IsInitReady() )
		return FALSE;
	//---- CPY 3/3/05 INTERNAL_XF_EDIT
	//return m_treeEditCntrl.OnSelectionChange();
	if(m_treeEditCntrl.OnSelectionChange())
		return true;
	
	Worksheet wks = Project.ActiveLayer();
	if(wks)
		return OnWksSelectionChange(wks);
	return false;
	//---- end 	INTERNAL_XF_EDIT	
}


BOOL	XFunctionDlg::OnSelectionTrack()
{
	if( !IsInitReady() )
		return FALSE;
	
	return m_treeEditCntrl.OnSelectionTrack();
}
*/
BOOL XFunctionDlg::OnActiveLayerChange( )
{
	//out_str("OnActiveLayerChange");
	return OnLayerChange();
}

BOOL XFunctionDlg::OnLayerChange()//--- CPY 3/3/05 INTERNAL_XF_EDIT
{
	if(!IsInitReady())
		return TRUE;
	
	//out_str("OnLayerChange");
//	return OnSelectionChange();
	return true;
}

BOOL XFunctionDlg::OnChangeAutoUpdate(Control cntrl)
{
	if(!isViewAdvanced()) // if advanced, allow user complete control
	{
		bool bIsAutoUpdate = m_btnAutoUpdate.Check;
		if(bIsAutoUpdate)
			m_comboAttachTo.SetCurSel(XFATTACH_AUTO);
		else
			m_comboAttachTo.SetCurSel(XFATTACH_NONE);			
	}
	return true;		
}

void XFunctionDlg::updateXFFileName()
{
	DECL_XF(xf)
	//--- CPY 3/18/05 KEEP_XF_NAME_FOR_INTERNAL
	//m_paramTree.XFname.strVal = XF.GetFunctionName();
	//---
	//out_str();
	//--- CPY 2/28/05 2-28-05 QA70-7447 INTENAL_NAME_GENERATION
	string str;
	xf.GetSourcePath(str);
	m_strInternalFilename = GetFileName(str, true);
	//---
}

//--------- CPY 6/2/05 XF_MADE_INTERNAL_OUTSIDE_DIALOG
//bool XFunction::CreateInternalOperation(bool bExecute, uint* pOpUID, bool bAutoUpdate)// = true = NULL = true;//CPY 6/2/05 XF_INTERNAL_UPDATE_WITHOUT_EXEC

bool XFunctionDlg::processXF(bool bCompile, bool bExecuteButton, uint* pOpUID)// = true, true = NULL);
{
#ifndef 	 _XF_LT_CALL_IN_VC //CPY 1/27/06
	DECL_XF(xf)
	if(bCompile && !xf.Compile(GetSafeHwnd()) )
		//return FALSE; ///DG 2/2/05
		return onAfterCompile(false);
	bool	bIsAutoUpdate = m_btnAutoUpdate.Check;
	if(isSaveToOperation(bIsAutoUpdate, bExecuteButton))
		m_bRunSuccess = xf.CreateInternalOperation(bExecuteButton, pOpUID, bIsAutoUpdate);
	else if(bExecuteButton)
	{
		m_bRunSuccess=xf.Evaluate(NULL, NULL);
	}
	updateShowButtons();
	
	return m_bRunSuccess;
#endif //#ifndef 	 _XF_LT_CALL_IN_VC //CPY 1/27/06

	//DECL_XF(xf)
	XFunction		xf(m_paramTree, isInternalXF());
	if (bCompile && xf.Compile())
		return onAfterCompile(false);
	bool			bIsAutoUpdate = m_btnAutoUpdate.Check;
	if(isSaveToOperation(bIsAutoUpdate, bExecuteButton))
		m_bRunSuccess = xf.CreateInternalOperation(bIsAutoUpdate, bExecuteButton, pOpUID);
	else if(bExecuteButton)
	{
		//m_bRunSuccess=xf.Evaluate(NULL, NULL);
		m_bRunSuccess=xf.Evaluate(NULL, NULL);
	}
	updateShowButtons();
	
	return m_bRunSuccess;
}
//---------

/*
bool XFunctionDlg::processXF(bool bCompile, bool bExecuteButton, uint* pOpUID)// = true, true = NULL);
{
	DECL_XF(xf)
	if(bCompile && !xf.Compile(GetSafeHwnd()) )
		//return FALSE; ///DG 2/2/05
		return onAfterCompile(false);

	/// ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH
	bool	bIsAutoUpdate = m_btnAutoUpdate.Check;
	bool	bIsSaveToOperation = isSaveToOperation(bIsAutoUpdate, bExecuteButton);
	DataRange	drInput, drOutput;
	DataRange	*pdrInput = NULL, *pdrOutput = NULL;
	
	
	if (bIsSaveToOperation)
	{
		drInput.Create();
		drOutput.Create();
		pdrInput = &drInput; 
		pdrOutput = &drOutput; 
	}
	/// end OPERATIONTREE_UPDATING_BACK_AND_FORTH
	int nSetXF = OPSETXFUNCTION_SET_MODIFIED;

	if(bExecuteButton)
	{
		/// ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH
		//m_bRunSuccess=xf.Evaluate();
		m_bRunSuccess=xf.Evaluate(pdrInput, pdrOutput);
		/// end OPERATIONTREE_UPDATING_BACK_AND_FORTH
		nSetXF = OPSETXFUNCTION_NOT_MODIFIED; // CPY 4/14/05 I found just clicking update check without clicking execute failed to add op
	}
	else
	{
		//---- CPY 6/2/05 XF_INTERNAL_UPDATE_WITHOUT_EXEC
		xf.Evaluate(pdrInput, pdrOutput, true, NULL, false);// walk through Evaluate but not actually calling XF
		//----
		m_bRunSuccess = true;
	}
	updateShowButtons();
	
	/// YuI 01/03/2005 v7.5183 QA70-7253 VECTORIAL_NUMERIC_FUNCTIONS
	if( m_bRunSuccess )
	{
		/// ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH
		//bool bIsAutoUpdate = m_btnAutoUpdate.Check;
		if(bIsSaveToOperation)
		/// end OPERATIONTREE_UPDATING_BACK_AND_FORTH
		{
			bool bInitOk;
			OperationBase& op = op_create("XFOperation", bInitOk);
			if( op && bInitOk )
			{
				if(pOpUID)
					*pOpUID = op.GetUID();
				/// ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH
				//return updateOperation(op, xf);
				return updateOperation(op, xf, pdrInput, pdrOutput, nSetXF);
				/// end OPERATIONTREE_UPDATING_BACK_AND_FORTH
			}
			
			if( op )
				op.DestroyInternal();
			
			return false;
		}
	}
	/// end VECTORIAL_NUMERIC_FUNCTIONS
	
	return m_bRunSuccess;
}
*/

/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
/*
///Iris 3/29/05 ADD_RECENT_FILE_LIST
HMENU 	XFunctionDlg::getDlgMenu()
{
	HWND 	hWnd = GetSafeHwnd();
	HMENU 	hMenu = GetMenu(hWnd);
	return hMenu;
}

bool    XFunctionDlg::insertFileList(bool bSeparator)
{
	HMENU 	hMenu = getDlgMenu();
	Menu 	myMenu(hMenu);
	
	int 	nNewID = IDC_XFM_RECENT_FILE_LIST_BEGIN;
	if(bSeparator)
		myMenu.InsertMenu(IDC_XFM_CLOSE, MF_SEPARATOR, IDC_XFM_SEPARATOR);
	
	for( int index=0; index<m_FileList.GetSize(); index++)
	{
		myMenu.InsertMenu(IDC_XFM_SEPARATOR, MF_STRING, nNewID++, m_FileList.GetDisplayName(index));
	}
	return true;
}

bool    XFunctionDlg::removeAllFileList(bool bSeparator)
{
	HMENU 	hMenu = getDlgMenu();
	Menu 	myMenu(hMenu);

	if(bSeparator)
		myMenu.RemoveMenu(IDC_XFM_SEPARATOR, MF_SEPARATOR);
	for(int index=0; index<MAX_RECENT_FILE_NUMBER; index++)
	{
		myMenu.RemoveMenu(IDC_XFM_RECENT_FILE_LIST_BEGIN + index, MF_STRING);
	}
	return true;

}

bool    XFunctionDlg::initRecentFileListMenu(bool bSeparator)
{
	//init m_FileList
	m_FileList.SetFileList(STR_INI_SECTION_XF_RECENT_FILE, STR_XF_FILE_FOLDER);	
	
	insertFileList(bSeparator);
	return true;

}

bool    XFunctionDlg::updateRecentFileListMenu(bool bSeparator)
{	
	removeAllFileList(bSeparator);	
	insertFileList(bSeparator);	
	
	return true;
	
}

bool 	XFunctionDlg::addUpdateRecentFileList(LPCSTR lpcszFilePath)
{
	m_FileList.Add(lpcszFilePath);
	updateRecentFileListMenu(false);
	
	return true;
}
*/
/// END 03/09/06 ADD_RECENT_FILE_LIST_CLASS

BOOL 	XFunctionDlg::OnSelMostRecentFileList(int nID)
{
	///Frank 3/31/05	GET_FILE_FROM_RECENTLY_FILE
	/// AW 03/09/06 ADD_RECENT_FILE_LIST_CLASS
	/*
	int nRecentlyFileIndex = 0;
	nRecentlyFileIndex = nID - IDC_XFM_RECENT_FILE_LIST_BEGIN;
	bool bUpdateSelToTop = false;
	if(nRecentlyFileIndex == 0)
		bUpdateSelToTop = true;
	
	string strXMLFile = m_FileList.Get(nRecentlyFileIndex);
	
	if(openXF(strXMLFile))
		addUpdateRecentFileList(strXMLFile);
	*/
	
	///Folger 06/20/07 ASK_SAVE_BEFORE_LOAD_XF
	if(!askCanExit())
		return false;
	///End ASK_SAVE_BEFORE_LOAD_XF
	
	string strXMLFile = m_MRFList.GetFromID(nID);
	
	if(openXF(strXMLFile))
		m_MRFList.AddUpdateRecentFileList(strXMLFile);
	/// END ADD_RECENT_FILE_LIST_CLASS

	//printf("%d\n", nID-IDC_XFM_RECENT_FILE_LIST_BEGIN);
	return true;
	///End	GET_FILE_FROM_RECENTLY_FILE
}
///end ADD_RECENT_FILE_LIST

BOOL 	XFunctionDlg::OnRun(Control cntrl)
{
	if(isInternalXF())
	{
		///Frank 4/6/05	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY
		//updateInternalXFtoOperation(true, true, true);
		updateInternalXFtoOperation(false, true, true);
		///End	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY
		return true;
	}

	updateDlgToXFTree();
	return processXF();
}

void XFunctionDlg::expandBottomPane(int nTab)//= -1)
{
	BitmapRadioButton brb=GetItem(IDC_XF_SHOW_BOTTOM);
	brb.Check=true;
	Control ctrl=GetItem(IDC_XF_BOTTOM_TAB);
	TabControl tab(ctrl);
	if(nTab >= 0)
		tab.SetCurSel(nTab);
	MultiPaneDlg::OnShowBottomPane(ctrl);
}
bool XFunctionDlg::onAfterCompile(bool bSuccess)
{
	if(bSuccess)
	{
		expandBottomPane(XF_OUTPUT_TAB);
		outputOpMsgLog("Compile successful.");
	}
	else
	{
		outputOpMsgLog("Compile fail...");
		expandBottomPane(XF_COMPILER_TAB);
		m_bRunSuccess=false;
	}
	updateShowButtons();
	return bSuccess;
}

void XFunctionDlg::onFunctionChange(bool bUpdateGUI)
{
	if(!IsInitReady())
		return;
	
	//if(!m_XFO.CheckChanged(m_paramTree))
	string strTemp;
	if( !m_paramTree.GetAttribute(STR_CHANGED_ATTRIB, strTemp) )
	{
		// m_XFO.MarkChanged(m_paramTree);
		string strTemp;
		m_paramTree.SetAttribute(STR_CHANGED_ATTRIB, strTemp);
		
	}
	if(bUpdateGUI)
		updateDialogTitle();
}
	
/// TD 2-14-05 QA70-7403 XFUNCTION_IDE
BOOL XFunctionDlg::OnCodeBuilder() 
{
	updateDlgToXFTree();
	//XFunction xf;
	//if(!m_strHeaderString.IsEmpty())
	//	xf.SetHeaderString(m_strHeaderString);
	//
	//xf.Create(m_paramTree);
	DECL_XF(xf)
	vector<point> &vp = xf.GetEditables();
	string strPath;
	if(xf.GetSourcePath(strPath, true))
	{
		//Visible = FALSE;
		string strTemp;
	//	if(getFilename(strTemp))
	//		OnFileSave();
		CodeBuilder.Open(strPath, vp, GetSafeHwnd());
		/// TD 9-12-05 QA70-7403 XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
		m_bSecondViewOpenInCodeBuilder = TRUE;
		/// end XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
		return true;
	}
	///Joseph 06/22/07 NOT_OPEN_CODE_BULIDER_IF_NO_XFNAME_AND_POPUP_MSG_BOX
	{
		MessageBox(NULL, _L("Please specify an X-Function name first."), _L("Reminder"), MB_OK);
	}
	///End NOT_OPEN_CODE_BULIDER_IF_NO_XFNAME_AND_POPUP_MSG_BOX
	return false;
}


/// TD 08-13-2007 SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION
BOOL XFunctionDlg::OnDynacontrolOptions(int nOption, int nUnused)
{

	if(DYNACONTROL_OPTION_RESOLVE_ACTIVE == nOption)
		return TRUE;

	return FALSE;
}
/// end SOME_DIALOGS_NEED_OPTION_TO_NOT_RESOLVE_ACTIVE_TO_CURRENT_SELECTION

BOOL XFunctionDlg::OnOCDocClose(UINT wParam, UINT lParam)
{
	//Visible = TRUE; 
	/// TD 9-12-05 QA70-7403 XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
	m_bSecondViewOpenInCodeBuilder = FALSE;
	/// end XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
	return TRUE;
}


/// TD 6-14-05 QA70-7803 XF_NO_LIMIT_EDITABLE_BLOCKS_SUPPORT
//BOOL XFunctionDlg::OnOCDocSave(LPCSTR lpcszInclude, LPCSTR lpcszBody)
BOOL XFunctionDlg::OnOCDocSave(StringArray& arrEditables, LPCSTR lpcsz)
// end XF_NO_LIMIT_EDITABLE_BLOCKS_SUPPORT
{
	/// TD 2-14-05 QA70-7534 SAVE_EDITABLE_LINES
	//string strOldHeader = m_paramTree.header.strVal;
	//string strOldCode = m_paramTree.code.strVal;
	//string strHeaderString		= okutil_code_to_edit(lpcszInclude, STC_CRNL_TO_NL|STC_EXPAND_TABS);
	//string strInplementation 	= okutil_code_to_edit(lpcszBody, STC_CRNL_TO_NL|STC_EXPAND_TABS|STC_PREPEND_UNTAB);
	//if(strOldHeader.Compare(strHeaderString) != 0 ||
	//	strOldCode.Compare(strInplementation) != 0)
	//{
	//	//SetInitReady(false);
	//	m_paramTree.header.strVal	= strHeaderString;	
	//	m_paramTree.code.strVal		= strInplementation;
	//	onFunctionChange();
	//	updateXFTreeToDlg();
	//	//SetInitReady(true);
	//}

	/// TD 6-14-05 QA70-7803 XF_NO_LIMIT_EDITABLE_BLOCKS_SUPPORT
	// if(m_XFO.CheckUpdateFunction(m_paramTree, lpcszInclude, lpcszBody))
	int nElements = arrEditables.GetSize();
	if(nElements < 2)
		return FALSE;
	BOOL bNeedUpdate = FALSE;
	/// YuI 07/28/05 MULTIPLE_XFUNCTION_EVENT_HANDLERS_SUPPORT
	/*
	if(nElements == 2)
		bNeedUpdate = m_XFO.CheckUpdateFunction(m_paramTree, arrEditables[0], arrEditables[1]);
	else
		bNeedUpdate = m_XFO.CheckUpdateFunction(m_paramTree, arrEditables[0], arrEditables[1], arrEditables[2]);
	*/
	
	// something is screwed up with 
	// arrEditables that is passed into function
	// had to do this trick to make call to m_XFO.CheckUpdateFunction 
	StringArray arrTemp;
	arrTemp.SetSize(arrEditables.GetSize());
	for( int ii = 0; ii < arrTemp.GetSize(); ii++ )
		arrTemp[ii] = arrEditables[ii];
	/// DSC 12/07/05 SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	// bNeedUpdate = m_XFO.CheckUpdateFunction(m_paramTree, arrTemp);
//	bNeedUpdate = xf_check_update_function(m_paramTree, arrTemp);
	bNeedUpdate = okutil_fo_check_update_function(&m_paramTree, &arrTemp);
	/// end SEPARATE_XFUNCTIONORGANIZER_FROM_XFUNCTION
	/// end MULTIPLE_XFUNCTION_EVENT_HANDLERS_SUPPORT
	
	if(bNeedUpdate)
	// end XF_NO_LIMIT_EDITABLE_BLOCKS_SUPPORT
	{
		onFunctionChange();
		updateXFTreeToDlg();
	}
	/// end SAVE_EDITABLE_LINES
	return TRUE;
}


BOOL XFunctionDlg::OnCompilerMessage(LPCSTR  lpcszErr, UINT nLineErr)
{
	if(lpcszErr)
		m_reCompilerOutput.Write(lpcszErr);
	if(nLineErr >= 0)
	{
		DECL_XF(xf)
		//string strName;
		//if(xf.GetSourcePath(strName, true))
		if(xf.UpdateEditables())
		{
			vector<point> &vp = xf.GetEditables();
			if(vp.GetSize() >= 2)
			{
				int nLineErrDlg = nLineErr - vp[1].x - 1;
				if(nLineErrDlg >= 0)
					m_reCode.Highlight(nLineErrDlg);
			}
		}
	}
	return TRUE;
}
/// end  XFUNCTION_IDE

/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
void XFunctionDlg::onChangeVarType(int nRow, int nCol)
{
	updateXFTreeToDlg();
}
/// end XYDATARANGE_PROPERTY_IMPLEMENTATION


//--- CPY 2/28/05 2-28-05 QA70-7447 INTENAL_NAME_GENERATION
BOOL XFunctionDlg::OnOCEditorChange(Control oCntrl)
{
	onFunctionChange();
	return true;
}

void XFunctionDlg::onChangeVarData(int nRow, int nCol)
{
	/// YuI 04/12/05 XVARIABLE_CONTEXT
	/// TD 5-10-2007 XFUNCTION_BUILDER_NOT_INFORM_ON_RANGE_CHANGE
	if(!isViewAdvanced())
	{
	/// end XFUNCTION_BUILDER_NOT_INFORM_ON_RANGE_CHANGE
	TreeNode tr = m_treeEditCntrl.GetTreeNode(nRow, nCol);
	TreeNode trVar = tr.Parent();

	DECL_XF(xf);
	xf.OnChangeVarData(trVar);
	}/// TD 5-10-2007 XFUNCTION_BUILDER_NOT_INFORM_ON_RANGE_CHANGE
	/// end XVARIABLE_CONTEXT
	if(isInternalXF())
	{
		//------ CPY 3/18/05 KEEP_XF_NAME_FOR_INTERNAL
		updateXFFileName();
		updateXFTreeToDlg();
		//------
	}
}
//---

/// Hong 01/18/08 v8.0788 FIX_XF_NO_VALID_NAME_CHECK_LEAD_XF_FAIL_RUN_CORRECTLY
void XFunctionDlg::onChangeVarName(int nRow, int nCol)
{
	if(!isViewAdvanced())
	{
		TreeNode tr = m_treeEditCntrl.GetTreeNode(nRow, nCol);	
		string strName = tr.strVal;
		strName.MakeValidCName();
		if ( tr.strVal != strName )
		{
			tr.strVal = strName;
			updateXFTreeToDlg();		
		}
	}
}
/// end FIX_XF_NO_VALID_NAME_CHECK_LEAD_XF_FAIL_RUN_CORRECTLY

BOOL	XFunctionDlg::OnUpdateInternalEdit()
{
	///Frank 4/6/05	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY
	///Should compile and execute
	///If bCompile and bExecuteButton = false, Operation will have empty input and output DataRange.
	///The operation will invalid in feature.....
	//updateInternalXFtoOperation(true); 
	bool bCompile = true, bExecuteButton = false;
	updateInternalXFtoOperation(true, bCompile ,bExecuteButton ); 
	///End	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	if( m_bChangeParam )
		OnClose();
	/// end XFOPERATION_CHANGE_PARAM
	return true;
}
BOOL	XFunctionDlg::OnCancelInternalEdit()
{
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	if( m_bChangeParam )
	{
		return OnClose();
	}
	/// end XFOPERATION_CHANGE_PARAM
	
	setXFEmpty(false);
	clearXFChanged();
	m_uidCurrentOp = 0;
	updateXFTreeToDlg();
	return true;
}

//--- CPY 3/3/05 INTERNAL_XF_EDIT
/// ML 3/21/2005 OPERATIONTREE_UPDATING_BACK_AND_FORTH
//bool XFunctionDlg::updateOperation(OperationBase& op, XFunction& xf)
//{
//	return op_set_x_function(op, xf, m_btnAutoUpdate.Check, isInternalXF());
//}

/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
/*
bool XFunctionDlg::updateOperation(OperationBase& op, XFunction& xf, DataRange *pdrInput, DataRange *pdrOutput, BOOL bSetModified)
{
	return op_set_x_function(op, xf, m_btnAutoUpdate.Check, isInternalXF(), pdrInput, pdrOutput, bSetModified);
}
*/
/*
bool XFunctionDlg::updateOperation(OperationBase& op, XFunction& xf, DataRange *pdrInput, DataRange *pdrOutput, int nCntrl)
{
	return op_set_x_function(op, xf, m_btnAutoUpdate.Check, isInternalXF(), pdrInput, pdrOutput, nCntrl);
}
*/
/// end XFOPERATION_CHANGE_PARAM
/// end OPERATIONTREE_UPDATING_BACK_AND_FORTH
/**
	There are four states of Internal mode.
	1: m_uidCurrentOp = 0 and XFchangded = false , a  new internal xf, not need update anything. 
	2: m_uidCurrentOp != 0 and XFChanged= true, internal function had been modify or Exevute but not update.
	3: m_uidCurrentOp != 0 and XFChanged = false, internal function had been update.
	4: m_uidCurrentOp = 0 and XFChanged = true,  internal function is new and not update now.
*/
bool XFunctionDlg::updateInternalXFtoOperation(bool bUpdateGUI, bool bCompile, bool bExecuteButton) // = false, false
{
	if(!isXFChanged())
		return true;
	
	updateDlgToXFTree();//CPY 4/20/05, was above isXFChanged, but if not change, no need to do this to make things faster
	
	//---- CPY 4/15/05 SWITCHING_OUTPUT_COL_IN_INTERNAL_SHOULD_USE_NEW_OP
	if(m_bIOChangedNeedOpReset)
		resetLinkedOperation(false);
	//----
		
	if(m_uidCurrentOp == 0) // may need to create new
	{
		//if(!m_wksCurrent) // not from a wks, so no need to create
		//	return false;
		/*
		if(!isVarHasIO())
			return false;
		*/
//--- CPY 4/14/05 AUTO_UPDATE_NOT_REALLY_NEEDED_TO_BE_SHOWN_IN_ALL_CASES
//		if( m_btnAutoUpdate.Check && !isAutoUpdatePossible() )
//			return false; //autoupdate must have inputs and outputs
//---		
		processXF(bCompile, bExecuteButton, &m_uidCurrentOp);
	}
	else
	{
		//--------- CPY 6/2/05 XF_MADE_INTERNAL_OUTSIDE_DIALOG
		//Operation& op = (Operation&)Project.GetOperationObject(m_uidCurrentOp);
		//DECL_XF(xf)
		///// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
		////	updateOperation(op, xf);
		//if( bExecuteButton )
		//	updateOperation(op, xf, NULL, NULL, OPSETXFUNCTION_EXECUTE);
		//else
		//	updateOperation(op, xf);
		///// end XFOPERATION_CHANGE_PARAM
		DECL_XF(xf)
		if( bExecuteButton )
			xf.UpdateInternalOperation(m_uidCurrentOp, OPSETXFUNCTION_EXECUTE);
		else
			xf.UpdateInternalOperation(m_uidCurrentOp);
		//--------- end XF_MADE_INTERNAL_OUTSIDE_DIALOG
	}
	///Frank 4/6/05	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY
	/*
	if(bExecuteButton) //if Execute, do not quite
		return true;
	
	setXFEmpty(false);
	clearXFChanged();
	m_uidCurrentOp = 0;
	if(bUpdateGUI)
		updateXFTreeToDlg();
	*/
	if(!bUpdateGUI && bExecuteButton) //if click Execute, quite; if user click Update Changed , do not quite.
		return true;
	
	if(m_uidCurrentOp == 0 )
	{
		setXFEmpty(false);
	}
	clearXFChanged();
	//m_uidCurrentOp = 0;		///Frank 4/7/05 Comment because after click update change button, next time update or execute the xf, m_uidCurrentOp = 0 can get the correct operation.....
	if(bUpdateGUI)
		updateXFTreeToDlg();
	///End	UPDATE_INTERNAL_XF_TO_OPERATION_BUG_EMPTY
	return true;
}
BOOL	XFunctionDlg::OnDeleteInternalXF()
{
	if(m_uidCurrentOp)
	{
		resetLinkedOperation(false);
		setXFEmpty(false);
		clearXFChanged();
		updateXFTreeToDlg();
	}
	return true;
}
BOOL XFunctionDlg::OnUiUpdateDeleteInternalXF(CmdUI cmd)
{
	/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	if( CheckDisableIfChangeParam(cmd) )
		return TRUE;
	/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	
	bool bEnable = isInternalXF();
	if(bEnable)
	{
		if(0==m_uidCurrentOp || isXFChanged())
			bEnable = false;
	}
	cmd.Enable(bEnable);
	return TRUE;
}
/// TD 9-12-05 QA70-7403 XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER
BOOL	XFunctionDlg::OnUiUpdateCompile(CmdUI cmd)
{
	cmd.Enable(!m_bSecondViewOpenInCodeBuilder);
	return TRUE;

}
/// end XFN_DISABLE_DLG_COMPILE_WHEN_OPEN_IN_CODE_BUILDER


//-------- CPY 4/15/05 SWITCHING_OUTPUT_COL_IN_INTERNAL_SHOULD_USE_NEW_OP
bool XFunctionDlg::resetLinkedOperation(bool bDelay)
{
	if(m_uidCurrentOp)
	{
		if(bDelay)
		{
			m_bIOChangedNeedOpReset = true;
			return true;
		}
		Operation& op = (Operation&)Project.GetOperationObject(m_uidCurrentOp);
		op_destroy_on_cancel(op, false);
		m_uidCurrentOp = 0;
		m_bIOChangedNeedOpReset = false;
		return true;
	}
	return false;
}
//--------		

bool XFunctionDlg::editInternalXFfromOperation(UINT uidOp, Worksheet& wks, int nRow, int nCol, bool bColSelected)
{
	if(uidOp != 0 && uidOp == m_uidCurrentOp)
	{
		//out_str("editing same OP, skipped...");
		return true;
	}
	
	updateInternalXFtoOperation(false);
	if( uidOp )
	{
		Operation& op = (Operation&)Project.GetOperationObject(uidOp);
		Column cc(wks, nCol);	
		//printf("col name = %s\n", cc.GetName());
		TreeNode trOp;
		op.GetTree(trOp);
		TreeNode trXF = tree_check_get_node(trOp, STR_OP_XF_NODE);
		m_paramTree.Replace(trXF.Clone());
		m_btnAutoUpdate.Check = trOp.Operation.AutoUpdate.nVal;
		//---- for internal, need to del external node
		TreeNode trXFname = trOp.GetNode(STR_OP_XF_EXTERNAL_NODE);
		if(trXFname)
			trXFname.Remove();
		//----
	}
	else
	{
		if(bColSelected)
			newColXF(wks, nCol, false);
		else
			setXFEmpty(false);
	}
	m_uidCurrentOp = uidOp;
	/*
	m_wksCurrent = wks;
	m_nColCurrent = nCol;
	m_nRowCurrent = nRow;
	*/
	clearXFChanged();
	updateXFTreeToDlg();
	return true;
}
///Frank 4/7/05   In debug mode, function OnWksSelectionChange will get wrong return...
BOOL XFunctionDlg::OnWksSelectionChange(Worksheet& wks)
{
	int r1, r2, c1, c2;
	int nSel = wks.GetSelectedRange(r1, c1, r2, c2);
	if(!isInternalXF())
		return false;
	if(isXFChanged()) // in the middle of editing, cannot start edit of another
		return false;
	//printf("sel=%X, r1=%d, c1=%d\n", nSel, r1, c1);
	if((nSel & WKS_SEL_ONE_COL) && (nSel & WKS_SEL_COLUMN))
	{	
		//Column cc(wks, c1);	
		if(r1<0) // whole col
			r1 = 0;
		UINT uidOp = wks.GetIncomingOperation(r1, c1);
		return editInternalXFfromOperation(uidOp, wks, r1, c1, true);
	}
	else
		return editInternalXFfromOperation(0, wks, r1, c1, false);
}


void XFunctionDlg::setViewAdvanced(int nSet, bool bReDraw) // 0, 1, -1 to toggle
{
	/// TD 5-21-07 QA80-9807 FASTER_EDITING_OF_RANGE_CONTROL
	if(m_bViewAdvanced && nSet <= 0)
	{
		m_DynaCntrl.AbjustFocusToSave();
	}
	/// end FASTER_EDITING_OF_RANGE_CONTROL
	if(nSet < 0)
	{
		if(!m_bViewAdvanced)// switch from simple to advanced view, need to update from Dialog to tree
			updateDlgToXFTree();

		m_bViewAdvanced = m_bViewAdvanced? 0 : 1;
	}
	else
		m_bViewAdvanced = nSet;	
		
	if(bReDraw)
	{
		redrawTopPaneFromTree();
		updateShowButtons();
	}
}

///Frank 4/2/05 move bNeedMakeClean = true to body of root isXFBasiccallyEmpty(),
// because in this case not need mark function change, others case will need update function changed.
BOOL XFunctionDlg::OnToggleInternalMode()
{
	// first need to check if external and need saving file
	//--- CPY 3/31/05 SWITCH_TO_INTERNAL_WITH_DEFAULT_DLG_SHOULD_SET_TO_EMPTY
	bool bNeedMakeClean = false;
	/*
	if(!isInternalXF())
	{
		if(isXFBasicallyEmpty())
		{
			setXFEmpty();
			bNeedMakeClean = true;
		}
		else if(isXFChanged())
		{
			if(MessageBox(GetSafeHwnd(), "Switch to internal mode without saving?", _L("X-Function"), MB_OKCANCEL) == IDCANCEL)
				return true;
		
		updateDlgToXFTree();
		}
	}
	else
		updateDlgToXFTree();
	*/
	if(isXFBasicallyEmpty())
	{
		setXFEmpty();
		bNeedMakeClean = true;
	}
	else if(isXFChanged())
	{
		if(!isInternalXF() && MessageBox(GetSafeHwnd(), "Switch to internal mode without saving?", _L("X-Function"), MB_OKCANCEL) == IDCANCEL)
			return true;
		updateDlgToXFTree();	
	}
	//---
	
	
	
	m_nInternalMode = isInternalXF()? XFMODE_EXTERNAL : XFMODE_INTERNAL_NORMAL;

	m_btnAutoUpdate.Check = isInternalXF()?true:false;// CPY 3/18/05 KEEP_XF_NAME_FOR_INTERNAL, default should be auto update
	
	if(!bNeedMakeClean)
		onFunctionChange(false);
	else if (isInternalXF())
	{
		Worksheet wks = Project.ActiveLayer();
		if(wks)
		{
			OnWksSelectionChange(wks);
			return true;
		}
	}	
	updateXFTreeToDlg(true);
	return true;
}



BOOL XFunctionDlg::OnConvertToInternal()
{
	if(isInternalXF())
		return true;
	OnToggleInternalMode();
	return true;
}

/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
BOOL	XFunctionDlg::OnChangeParamOk(Control ctrl)
{
	updateDlgToXFTree();
	m_bChangeParamOk = TRUE;
	return OnClose();
}

BOOL	XFunctionDlg::OnChangeParamCancel(Control ctrl)
{
	return OnClose();
}
/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
//------ Folger 07/31/07 CORRECT_OPEN_USER_XF_BEHAVIOR
BOOL XFunctionDlg::openFile(string strInitPath, bool bKeepInReg)
{
	CheckMakePath(strInitPath);		//------ Folger 03/25/08 NEED_TO_CHECK_MAKE_XFUNCTION_FOLDER
	
	vector<string> vsExt={STR_XF_FILE_EXT_SPEC};
	string strXMLFile=GetOpenBox(vsExt, strInitPath);
	
	if(!strXMLFile.IsEmpty())
	{
		if(!askCanExit())
			return false;
	}
		
	if(openXF(strXMLFile))
	{
		m_MRFList.AddUpdateRecentFileList(strXMLFile);
		if (bKeepInReg)
			dlg_save_to_registry(STR_DIALOG_NAME, STR_DEFAULT_OPEN_PATH, GetFilePath(strXMLFile));
	}
	return true;
}
//------ End CORRECT_OPEN_USER_XF_BEHAVIOR



bool OpenXFDialog(TreeNode& tr = NULL, UINT uidOperation = 0)
{
	static XFunctionDlg  s_XFDlg;
	
	if( tr != NULL )
	{
		Window winDlg = s_XFDlg.GetWindow();
		if(winDlg)
		{
			out_str("ChangeParam can not be executed while X-Function Dialog is open.\nPlease close X-Function dialog and try again");
			return false;
		}
		
		XFunctionDlg dlg;
		dlg.PrepareForChangeParamOperation(tr, uidOperation);
		dlg.DoModalEx();
		/// YuI 08/09/05 XFUNCTION_OPERATION_CHANGE_PARAM_BUG
		//	return true;
		if( dlg.IsChangeParamOk() )
		{
			dlg.UpdateTreeAfterChangeParamOk(tr);	
			return TRUE;
		}
		
		return FALSE;
		/// end XFUNCTION_OPERATION_CHANGE_PARAM_BUG
	}
	

	Window winDlg = s_XFDlg.GetWindow();
	if(winDlg)
	{
		out_str("X-Function Dialog already open");
		return false;
	}
	
	// Global GetWindow() function return Origin's main window handle, which we want to be
	// the parent of our little Modeless dialog
	/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
	s_XFDlg.Reset(); 
	/// end XFOPERATION_CHANGE_PARAM
	s_XFDlg.Create( GetWindow() ); 
	return true;
}

#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

bool XFOpen()
{
	return OpenXFDialog();	
}
